/*
 * Decompiled with CFR 0.152.
 */
package asos;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.util.StringTokenizer;

public class AsosFTPSession {
    public String host;
    public int port;
    public String username;
    public String password;
    public String acct;
    protected Socket sessionSock;
    protected BufferedReader inStream;
    protected DataOutputStream outStream;

    public AsosFTPSession() {
    }

    public AsosFTPSession(String string, String string2, String string3) throws IOException {
        this.host = string;
        this.port = 21;
        this.username = string2;
        this.password = string3;
        this.logon();
    }

    public AsosFTPSession(String string, String string2, String string3, String string4) throws IOException {
        this.host = string;
        this.port = 21;
        this.username = string2;
        this.password = string3;
        this.acct = string4;
        this.logon();
    }

    public AsosFTPSession(String string, int n, String string2, String string3, boolean bl) throws IOException {
        this.host = string;
        this.port = n;
        if (this.port <= 0) {
            this.port = 21;
        }
        this.username = string2;
        this.password = string3;
        if (bl) {
            this.logon();
        }
    }

    public AsosFTPSession(String string, int n, String string2, String string3, String string4, boolean bl) throws IOException {
        this.host = string;
        this.port = n;
        if (this.port <= 0) {
            this.port = 21;
        }
        this.username = string2;
        this.password = string3;
        this.acct = string4;
        if (bl) {
            this.logon();
        }
    }

    public void close() throws IOException {
        this.sessionSock.close();
        this.sessionSock = null;
    }

    public void connect() throws IOException {
        this.sessionSock = new Socket(this.host, this.port);
        this.inStream = new BufferedReader(new InputStreamReader(this.sessionSock.getInputStream()));
        this.outStream = new DataOutputStream(this.sessionSock.getOutputStream());
    }

    public String doCommand(String string) throws IOException {
        this.outStream.writeBytes(string + "\n");
        String string2 = this.getResponse();
        return string2;
    }

    public String getResponse() throws IOException {
        String string;
        String string2 = "";
        do {
            if ((string = this.inStream.readLine()) == null) {
                throw new IOException("Bad response from server.");
            }
            if (string.length() < 3) {
                throw new IOException("Bad response from server.");
            }
            string2 = string2 + string + "\n";
        } while (string.length() != 3 && string.charAt(3) == '-');
        return string2;
    }

    public void logon() throws IOException {
        this.connect();
        String string = this.getResponse();
        if (string.charAt(0) != '2') {
            throw new IOException(string);
        }
        string = this.doCommand("USER " + this.username);
        if (string.charAt(0) == '3' && (string = this.doCommand("PASS " + this.password)).charAt(0) == '3') {
            string = this.doCommand("ACCT " + this.acct);
        }
        if (string.charAt(0) != '2') {
            throw new IOException(string);
        }
    }

    protected synchronized Socket doPasvPort() throws IOException {
        String string = this.doCommand("PASV");
        if (string.charAt(0) != '2') {
            throw new IOException(string);
        }
        int n = string.lastIndexOf(40);
        int n2 = string.lastIndexOf(41);
        if (n < 0 || n2 < 0 || n >= n2) {
            throw new IOException("PASV response format error");
        }
        String string2 = string.substring(n + 1, n2);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        int[] nArray = new int[6];
        int n3 = 0;
        while (n3 < 6 && stringTokenizer.hasMoreTokens()) {
            try {
                nArray[n3] = Integer.valueOf(stringTokenizer.nextToken());
            }
            catch (Exception exception) {
                throw new IOException("PASV response format error");
            }
            ++n3;
        }
        Socket socket = new Socket(this.host, (nArray[4] << 8) + nArray[5]);
        return socket;
    }

    public byte[] get(String string) throws IOException {
        return this.get(string, true);
    }

    public synchronized byte[] get(String string, boolean bl) throws IOException {
        Object object;
        if (bl ? ((String)(object = this.doCommand("TYPE I"))).charAt(0) != '2' : ((String)(object = this.doCommand("TYPE A"))).charAt(0) != '2') {
            throw new IOException((String)object);
        }
        object = this.doPasvPort();
        String string2 = this.doCommand("RETR " + string);
        if (string2.charAt(0) != '1') {
            ((Socket)object).close();
            throw new IOException(string2);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (bl) {
            int n;
            InputStream inputStream = ((Socket)object).getInputStream();
            while ((n = inputStream.read()) >= 0) {
                byteArrayOutputStream.write(n);
            }
        } else {
            String string3;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(((Socket)object).getInputStream()));
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            while ((string3 = bufferedReader.readLine()) != null) {
                printStream.println(string3);
            }
        }
        ((Socket)object).close();
        string2 = this.getResponse();
        if (string2.charAt(0) != '2') {
            throw new IOException(string2);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public synchronized void put(String string, byte[] byArray) throws IOException {
        this.put(string, byArray, true);
    }

    public synchronized void put(String string, byte[] byArray, boolean bl) throws IOException {
        Object object;
        if (bl ? ((String)(object = this.doCommand("TYPE I"))).charAt(0) != '2' : ((String)(object = this.doCommand("TYPE A"))).charAt(0) != '2') {
            throw new IOException((String)object);
        }
        object = this.doPasvPort();
        String string2 = this.doCommand("STOR " + string);
        if (string2.charAt(0) != '1') {
            ((Socket)object).close();
            throw new IOException(string2);
        }
        if (bl) {
            OutputStream outputStream = ((Socket)object).getOutputStream();
            outputStream.write(byArray);
        } else {
            String string3;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(byArray)));
            DataOutputStream dataOutputStream = new DataOutputStream(((Socket)object).getOutputStream());
            while ((string3 = bufferedReader.readLine()) != null) {
                dataOutputStream.writeBytes(string3 + "\r");
            }
        }
        ((Socket)object).close();
        string2 = this.getResponse();
        if (string2.charAt(0) != '2') {
            throw new IOException(string2);
        }
    }

    public synchronized void put(String string, String string2, File file) throws IOException {
        String string3 = this.doCommand("TYPE I");
        if (string3.charAt(0) != '2') {
            throw new IOException(string3);
        }
        Socket socket = this.doPasvPort();
        string3 = this.doCommand("CWD " + string2);
        if (string3.charAt(0) != '2') {
            socket.close();
            throw new IOException(string3);
        }
        string3 = this.doCommand("STOR " + string);
        if (string3.charAt(0) != '1') {
            socket.close();
            throw new IOException(string3);
        }
        OutputStream outputStream = socket.getOutputStream();
        FileInputStream fileInputStream = new FileInputStream(file);
        int n = 0;
        byte[] byArray = new byte[1000];
        while ((n = fileInputStream.read(byArray)) > 0) {
            outputStream.write(byArray, 0, n);
        }
        socket.close();
        string3 = this.getResponse();
        if (string3.charAt(0) != '2') {
            throw new IOException(string3);
        }
    }
}

