/*
 * Decompiled with CFR 0.152.
 */
package asos;

import asos.AsosExposurePanel;
import asos.AsosFTPSession;
import asos.AsosImageLoaderPanel;
import asos.AsosMailer;
import asos.AsosSoundLoaderPanel;
import asos.AsosStationInfoPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class AsosAppController
extends JPanel
implements ActionListener {
    private JPanel asosDisplayedPanel;
    private JPanel defaultPanel;
    private AsosImageLoaderPanel imageLoaderPanel;
    private AsosSoundLoaderPanel soundLoaderPanel;
    private AsosStationInfoPanel stationInfoPanel;
    private AsosExposurePanel exposurePanel;
    private AsosMailer mailerPanel;
    private JFileChooser chooser;
    private String wmoID;
    private File[] files;
    private File textFile;
    private boolean infoSet;
    private boolean expSet;
    private String asciiInfoData;
    private String asciiExpData;
    private File zipArchive;
    private String emailMessage;
    private String remoteHost = new String("ftp.ncdc.noaa.gov");
    private String remoteDir = new String("pub/upload");
    private String managerEmail = new String("David.P.Bowman@noaa.gov");
    private String asosGroupEmail = new String("asosproject@aoml.noaa.gov");
    private JLabel statusLabel;
    private JButton sendButton;

    public AsosAppController() {
        this.files = new File[11];
        this.chooser = new JFileChooser();
        this.defaultPanel = new JPanel();
        this.defaultPanel.setLayout(new BorderLayout());
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.stationInfoPanel = new AsosStationInfoPanel(this);
        jTabbedPane.add("Station Information", this.stationInfoPanel);
        this.exposurePanel = new AsosExposurePanel(this);
        jTabbedPane.add("Exposure Comments", this.exposurePanel);
        Box box = Box.createVerticalBox();
        this.imageLoaderPanel = new AsosImageLoaderPanel(this);
        box.add(this.imageLoaderPanel);
        this.soundLoaderPanel = new AsosSoundLoaderPanel(this);
        box.add(this.soundLoaderPanel);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        JButton jButton = new JButton("Load Directory");
        jButton.setActionCommand("loaddir");
        jButton.addActionListener(this);
        jPanel.add(jButton);
        jPanel.setVisible(true);
        box.add(jPanel);
        jTabbedPane.add("Load Station Files", box);
        this.defaultPanel.add((Component)jTabbedPane, "Center");
        Box box2 = Box.createHorizontalBox();
        this.statusLabel = new JLabel("Status: ...");
        box2.add(this.statusLabel);
        box2.add(Box.createHorizontalGlue());
        this.sendButton = new JButton("Compress and Send");
        this.sendButton.setActionCommand("send");
        this.sendButton.addActionListener(this);
        box2.add(this.sendButton);
        this.defaultPanel.add((Component)box2, "South");
        this.defaultPanel.setVisible(true);
        this.add(this.defaultPanel);
        this.mailerPanel = new AsosMailer();
        this.mailerPanel.setMessage("nick.carrasco@noaa.gov", "test", "this is a test message\ntest\ntest");
        this.mailerPanel.setVisible(false);
        this.add(this.mailerPanel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        this.statusLabel.setText(string);
        if (string.equalsIgnoreCase("wmoid")) {
            this.wmoID = new String(this.stationInfoPanel.getStationID().toUpperCase());
            this.stationInfoPanel.setWMO(this.wmoID);
            this.statusLabel.setText(this.stationInfoPanel.getStationID());
            this.imageLoaderPanel.setStationLabelText(this.stationInfoPanel.getStationID());
        } else if (string.equalsIgnoreCase("statinfo")) {
            this.statusLabel.setText("getting station info");
            this.asciiInfoData = this.stationInfoPanel.getAsciiInfo();
            if (this.asciiInfoData == null) {
                JOptionPane.showMessageDialog(this, "<HTML><FONT color=\"RED\">Please check that all fields in the Station Info Pane are filled</FONT></HTML>", "Error", 2);
            } else {
                this.infoSet = true;
            }
        } else if (string.equalsIgnoreCase("expinfo")) {
            this.statusLabel.setText("getting exposure info");
            this.asciiExpData = this.exposurePanel.getAsciiInfo();
            if (this.asciiExpData == null) {
                JOptionPane.showConfirmDialog(this, "<HTML><FONT color=\"RED\">Please fill in the exposure comments</FONT></HTML>", "Warning", 2);
            } else {
                this.expSet = true;
            }
        } else if (string.equalsIgnoreCase("loaddir")) {
            this.chooser.setFileSelectionMode(1);
            int n = this.chooser.showOpenDialog(this);
            if (n == 0) {
                this.statusLabel.setText(this.chooser.getSelectedFile().getName());
                File file = this.chooser.getSelectedFile();
                this.getFilesFromDirectory(file);
            }
            this.chooser.setFileSelectionMode(2);
        } else if (string.equalsIgnoreCase("360")) {
            int n = this.chooser.showOpenDialog(this);
            if (n == 0) {
                this.statusLabel.setText(this.chooser.getSelectedFile().getName());
                this.files[3] = this.chooser.getSelectedFile();
                this.imageLoaderPanel.setLoadImage360Icon(this.files[3].getAbsolutePath());
            }
        } else if (string.equalsIgnoreCase("045")) {
            int n = this.chooser.showOpenDialog(this);
            if (n == 0) {
                this.statusLabel.setText(this.chooser.getSelectedFile().getName());
                this.files[4] = this.chooser.getSelectedFile();
                this.imageLoaderPanel.setLoadImage045Icon(this.files[4].getAbsolutePath());
            }
        } else if (string.equalsIgnoreCase("090")) {
            int n = this.chooser.showOpenDialog(this);
            if (n == 0) {
                this.statusLabel.setText(this.chooser.getSelectedFile().getName());
                this.files[5] = this.chooser.getSelectedFile();
                this.imageLoaderPanel.setLoadImage090Icon(this.files[5].getAbsolutePath());
            }
        } else if (string.equalsIgnoreCase("135")) {
            int n = this.chooser.showOpenDialog(this);
            if (n == 0) {
                this.statusLabel.setText(this.chooser.getSelectedFile().getName());
                this.files[6] = this.chooser.getSelectedFile();
                this.imageLoaderPanel.setLoadImage135Icon(this.files[6].getAbsolutePath());
            }
        } else if (string.equalsIgnoreCase("180")) {
            int n = this.chooser.showOpenDialog(this);
            if (n == 0) {
                this.statusLabel.setText(this.chooser.getSelectedFile().getName());
                this.files[7] = this.chooser.getSelectedFile();
                this.imageLoaderPanel.setLoadImage180Icon(this.files[7].getAbsolutePath());
            }
        } else if (string.equalsIgnoreCase("225")) {
            int n = this.chooser.showOpenDialog(this);
            if (n == 0) {
                this.statusLabel.setText(this.chooser.getSelectedFile().getName());
                this.files[8] = this.chooser.getSelectedFile();
                this.imageLoaderPanel.setLoadImage225Icon(this.files[8].getAbsolutePath());
            }
        } else if (string.equalsIgnoreCase("270")) {
            int n = this.chooser.showOpenDialog(this);
            if (n == 0) {
                this.statusLabel.setText(this.chooser.getSelectedFile().getName());
                this.files[9] = this.chooser.getSelectedFile();
                this.imageLoaderPanel.setLoadImage270Icon(this.files[9].getAbsolutePath());
            }
        } else if (string.equalsIgnoreCase("315")) {
            int n = this.chooser.showOpenDialog(this);
            if (n == 0) {
                this.statusLabel.setText(this.chooser.getSelectedFile().getName());
                this.files[10] = this.chooser.getSelectedFile();
                this.imageLoaderPanel.setLoadImage315Icon(this.files[10].getAbsolutePath());
            }
        } else if (string.equalsIgnoreCase("location")) {
            int n = this.chooser.showOpenDialog(this);
            if (n == 0) {
                this.statusLabel.setText(this.chooser.getSelectedFile().getName());
                this.files[1] = this.chooser.getSelectedFile();
            }
        } else if (string.equalsIgnoreCase("obstacle")) {
            int n = this.chooser.showOpenDialog(this);
            if (n == 0) {
                this.statusLabel.setText(this.chooser.getSelectedFile().getName());
                this.files[2] = this.chooser.getSelectedFile();
            }
        } else if (string.equalsIgnoreCase("send")) {
            this.statusLabel.setText("creating ascii file");
            if (!this.createAsciiFile()) {
                JOptionPane.showMessageDialog(this, "<HTML><FONT color=\"RED\">Please check that all fields in the Station and Exposure Panes are filled</FONT></HTML>", "Error", 2);
                return;
            }
            this.statusLabel.setText("creating zip file");
            if (!this.createZipArchive()) {
                JOptionPane.showConfirmDialog(this, "<HTML><FONT color=\"RED\">Please check that you selected all the various files</FONT></HTML>", "Error", 2);
                return;
            }
            this.statusLabel.setText("ftping zip file");
            if (!this.sendZipArchive()) {
                JOptionPane.showMessageDialog(this, "<HTML><FONT color=\"RED\">Error sending zipped station infor, please try again later</FONT></HTML>", "Error", 2);
                return;
            }
            this.statusLabel.setText("generating email to " + this.managerEmail);
            String string2 = "ASOS_Station_" + this.wmoID + "_Submission";
            String string3 = "This is a notice that ASOS station " + this.wmoID + "<br>has been sent to " + this.remoteHost;
            string3 = string3 + "<br>filename is " + this.wmoID + ".zip";
            string3 = string3 + "<br>Thank you";
            this.mailerPanel.setMessage(this.managerEmail, string2, string3);
            this.defaultPanel.setVisible(false);
            this.mailerPanel.setVisible(true);
        }
    }

    void getFilesFromDirectory(File file) {
        this.statusLabel.setText("Loading files from " + file.getName());
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                String string = fileArray[n].getName();
                if (string.indexOf("000") != -1 || string.indexOf("360") != -1) {
                    this.files[3] = fileArray[n];
                    this.imageLoaderPanel.setLoadImage360Icon(this.files[3].getAbsolutePath());
                } else if (string.indexOf("045") != -1) {
                    this.files[4] = fileArray[n];
                    this.imageLoaderPanel.setLoadImage045Icon(this.files[4].getAbsolutePath());
                } else if (string.indexOf("090") != -1) {
                    this.files[5] = fileArray[n];
                    this.imageLoaderPanel.setLoadImage090Icon(this.files[5].getAbsolutePath());
                } else if (string.indexOf("135") != -1) {
                    this.files[6] = fileArray[n];
                    this.imageLoaderPanel.setLoadImage135Icon(this.files[6].getAbsolutePath());
                } else if (string.indexOf("180") != -1) {
                    this.files[7] = fileArray[n];
                    this.imageLoaderPanel.setLoadImage180Icon(this.files[7].getAbsolutePath());
                } else if (string.indexOf("225") != -1) {
                    this.files[8] = fileArray[n];
                    this.imageLoaderPanel.setLoadImage225Icon(this.files[8].getAbsolutePath());
                } else if (string.indexOf("270") != -1) {
                    this.files[9] = fileArray[n];
                    this.imageLoaderPanel.setLoadImage270Icon(this.files[9].getAbsolutePath());
                } else if (string.indexOf("315") != -1) {
                    this.files[10] = fileArray[n];
                    this.imageLoaderPanel.setLoadImage315Icon(this.files[10].getAbsolutePath());
                } else if (string.indexOf("1.wav") != -1) {
                    this.files[1] = fileArray[n];
                } else if (string.indexOf("2.wav") != -1) {
                    this.files[2] = fileArray[n];
                }
                ++n;
            }
        }
    }

    boolean createAsciiFile() {
        try {
            this.textFile = new File(this.wmoID + "info.txt");
            this.textFile.deleteOnExit();
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.textFile));
            if (!this.infoSet) {
                JOptionPane.showMessageDialog(this, "<HTML><FONT color=\"RED\">Please check that all fields in the Station Info Pane are filled</FONT></HTML>", "Error", 2);
                return false;
            }
            bufferedWriter.write(this.stationInfoPanel.getAsciiInfo());
            bufferedWriter.flush();
            if (!this.expSet) {
                JOptionPane.showMessageDialog(this, "<HTML><FONT color=\"RED\">Please fill in the exposure comments</FONT></HTML>", "Warning", 2);
                return false;
            }
            bufferedWriter.write(this.exposurePanel.getAsciiInfo());
            bufferedWriter.close();
            this.files[0] = this.textFile;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    boolean createZipArchive() {
        int n = 0;
        while (n < this.files.length) {
            if (this.files[n] == null) {
                return false;
            }
            ++n;
        }
        try {
            this.zipArchive = File.createTempFile(this.wmoID, ".zip");
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(this.zipArchive));
            zipOutputStream.putNextEntry(new ZipEntry(this.wmoID + "/"));
            int n2 = 0;
            while (n2 < this.files.length) {
                this.statusLabel.setText(n2 + " Adding " + this.files[n2].getName() + " to " + this.wmoID + "/" + this.files[n2].getName());
                FileInputStream fileInputStream = new FileInputStream(this.files[n2]);
                ZipEntry zipEntry = n2 < 3 ? new ZipEntry(this.wmoID + "/" + this.files[n2].getName()) : new ZipEntry(this.wmoID + "/" + this.wmoID + this.files[n2].getName());
                zipOutputStream.putNextEntry(zipEntry);
                int n3 = 0;
                byte[] byArray = new byte[1000];
                while ((n3 = fileInputStream.read(byArray)) > 0) {
                    zipOutputStream.write(byArray, 0, n3);
                }
                ((FilterOutputStream)zipOutputStream).flush();
                zipOutputStream.closeEntry();
                ++n2;
            }
            ((FilterOutputStream)zipOutputStream).flush();
            zipOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    boolean sendZipArchive() {
        String string = new String("anonymous");
        String string2 = this.stationInfoPanel.getEmail();
        String string3 = new String(this.wmoID + ".zip");
        try {
            AsosFTPSession asosFTPSession = new AsosFTPSession(this.remoteHost, string, string2);
            asosFTPSession.logon();
            asosFTPSession.put(string3, this.remoteDir, this.zipArchive);
            asosFTPSession.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }
}

