/******************************************************
* Name: CSerialPortException.h
* Desc: Serial port exception Class header file
* Date: 08/15/2009
* Pgmr: Ibis Gonzalez
******************************************************/

#define ERR_MSS_NO_OPEN				"Could not open the port"
#define ERR_MSS_NO_CONFIG			"Unable to configure the port"
#define ERR_MSS_NO_SET_TIMEOUT		"Unable to set the time-out parameters"
#define ERR_MSS_NO_SPEC_PORTNUMBER	"Port number no specified"
#define ERR_MSS_NO_CLOSE			"Could not close the port"
#define ERR_MSS_NO_WRITE			"Unable to write the Command"
#define ERR_MSS_NO_READ				"Unable to read the Response"
#define ERR_MSS_NO_CREATE_EVENT		"Failed in call to create event"
#define ERR_MSS_NO_CLOSE_EVENT		"Failed in call to close event"

class CSerialPortException : public CException
{
	DECLARE_DYNAMIC(CSerialPortException);

public:

	CSerialPortException(CString strMessage);
	CString& GetErrorMessage();

private:
	// members
	CString m_ErrorMessage;
};
