// CIniFileWriter.h: interface for the CIniFileWriter class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_CINIFILEWRITER_H__5DA862FB_F0FF_474F_B01A_99974298986F__INCLUDED_)
#define AFX_CINIFILEWRITER_H__5DA862FB_F0FF_474F_B01A_99974298986F__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "CIniFile.h"

class CIniFileWriter : public CIniFile  
{
public:
	CIniFileWriter( string const iniPath = "");
	virtual ~CIniFileWriter();

  // Sets value of [sectionname] keyname =.
  // Specify the optional paramter as false (0) if you do not want it to create
  // the section if it doesn't exist. Returns true if data entered, false otherwise.
  // Overloaded to accept string, int, and double.
  bool SetValueI( string const sectionname, string const keyname, int const value, bool const create = true);
  bool SetValueB( string const sectionname, string const keyname, bool const value, bool const create = true) {
    return SetValueI( sectionname, keyname, int(value), create);
  }
  bool SetValueF( string const sectionname, string const keyname, double const value, bool const create = true);
  bool SetValueV( string const sectionname, string const keyname, char *format, ...);

};

#endif // !defined(AFX_CINIFILEWRITER_H__5DA862FB_F0FF_474F_B01A_99974298986F__INCLUDED_)
