// CIniFileWriter.cpp: implementation of the CIniFileWriter class.
//
//////////////////////////////////////////////////////////////////////

#include <strstream>

using namespace std;

// C Includes
#include <stdarg.h>
#include <ctype.h>

#include "CIniFileWriter.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CIniFileWriter::CIniFileWriter( string const iniPath):
	CIniFile(iniPath)
{

}

CIniFileWriter::~CIniFileWriter()
{

}

bool CIniFileWriter::SetValueI( string const sectionname, string const keyname, int const value, bool const create)
{
  char svalue[MAX_VALUE];

  sprintf( svalue, "%d", value);
  return SetValue( sectionname, keyname, svalue);
}

bool CIniFileWriter::SetValueF( string const sectionname, string const keyname, double const value, bool const create)
{
  char svalue[MAX_VALUE];

  sprintf( svalue, "%f", value);
  return SetValue( sectionname, keyname, svalue);
}

bool CIniFileWriter::SetValueV( string const sectionname, string const keyname, char *format, ...)
{
  va_list args;
  char value[MAX_VALUE];

  va_start( args, format);
  vsprintf( value, format, args);
  va_end( args);
  return SetValue( sectionname, keyname, value);
}

