// CIniFileReader.h: interface for the CIniFileReader class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_CINIFILEREADER_H__BC052E51_E3B1_499D_86B4_070A014CA7D3__INCLUDED_)
#define AFX_CINIFILEREADER_H__BC052E51_E3B1_499D_86B4_070A014CA7D3__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "CIniFile.h"

class CIniFileReader : public CIniFile  
{
public:
	CIniFileReader( string const iniPath = "");
	virtual ~CIniFileReader();

  // Gets value of [sectionname] keyname =.
  // Overloaded to return string, int, and double.
  // Returns defValue if section/key not found.
  string GetValue( unsigned const sectionID, unsigned const keyID, string const defValue = "") const;
  string GetValueS(string const sectionname, string const keyname, string const defValue = "") const; 
  int    GetValueI(string const sectionname, string const keyname, int const defValue = 0) const;
  bool   GetValueB(string const sectionname, string const keyname, bool const defValue = false) const {
    return bool( GetValueI( sectionname, keyname, int( defValue)));
  }
  double   GetValueF(string const sectionname, string const keyname, double const defValue = 0.0) const;
  // This is a variable length formatted GetValue routine. All these voids
  // are required because there is no vsscanf() like there is a vsprintf().
  // Only a maximum of 8 variable can be read.
  unsigned GetValueV( string const sectionname, string const keyname, char *format,
		      void *v1 = 0, void *v2 = 0, void *v3 = 0, void *v4 = 0,
  		      void *v5 = 0, void *v6 = 0, void *v7 = 0, void *v8 = 0,
  		      void *v9 = 0, void *v10 = 0, void *v11 = 0, void *v12 = 0,
  		      void *v13 = 0, void *v14 = 0, void *v15 = 0, void *v16 = 0);

};

#endif // !defined(AFX_CINIFILEREADER_H__BC052E51_E3B1_499D_86B4_070A014CA7D3__INCLUDED_)
