// CIniFileReader.cpp: implementation of the CIniFileReader class.
//
//////////////////////////////////////////////////////////////////////

#include <strstream>

using namespace std;

#include "CIniFileReader.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CIniFileReader::CIniFileReader( string const iniPath):
	CIniFile(iniPath)
{
}

CIniFileReader::~CIniFileReader()
{

}

string CIniFileReader::GetValue( unsigned const sectionID, unsigned const keyID, string const defValue) const
{
  if ( sectionID < sections.size() && keyID < sections[sectionID].keys.size())
    return sections[sectionID].values[keyID];
  return defValue;
}

string CIniFileReader::GetValueS( string const sectionname, string const keyname, string const defValue) const
{
  long sectionID = FindSection( sectionname);
  if ( sectionID == noID)
    return defValue;

  long keyID = FindKey( unsigned(sectionID), keyname);
  if ( keyID == noID)
    return defValue;

  return sections[sectionID].values[keyID];
}

int CIniFileReader::GetValueI(string const sectionname, string const keyname, int const defValue) const
{
  char svalue[MAX_VALUE];

  sprintf( svalue, "%d", defValue);
  return atoi( GetValueS( sectionname, keyname, svalue).c_str()); 
}

double CIniFileReader::GetValueF(string const sectionname, string const keyname, double const defValue) const
{
  char svalue[MAX_VALUE];

  sprintf( svalue, "%f", defValue);
  return atof( GetValueS( sectionname, keyname, svalue).c_str()); 
}

// 16 variables may be a bit of over kill, but hey, it's only code.
unsigned CIniFileReader::GetValueV( string const sectionname, string const keyname, char *format,
			      void *v1, void *v2, void *v3, void *v4,
  			      void *v5, void *v6, void *v7, void *v8,
  			      void *v9, void *v10, void *v11, void *v12,
  			      void *v13, void *v14, void *v15, void *v16)
{
  string   value;
  // va_list  args;
  unsigned nVals;


  value = GetValueS( sectionname, keyname);
  if ( !value.length())
    return false;
  // Why is there not vsscanf() function. Linux man pages say that there is
  // but no compiler I've seen has it defined. Bummer!
  //
  // va_start( args, format);
  // nVals = vsscanf( value.c_str(), format, args);
  // va_end( args);

  nVals = sscanf( value.c_str(), format,
		  v1, v2, v3, v4, v5, v6, v7, v8,
		  v9, v10, v11, v12, v13, v14, v15, v16);

  return nVals;
}
