// CExternalSerialWatchdog.h: interface for the CExternalSerialWatchdog class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_CEXTERNALSERIALWATCHDOG_H__759C8142_BD2A_41BB_92B9_9C508586AF07__INCLUDED_)
#define AFX_CEXTERNALSERIALWATCHDOG_H__759C8142_BD2A_41BB_92B9_9C508586AF07__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "SerialPortPJ.h"

#define COMAND_0x20			0x20	// Reset PC Now
#define COMAND_0x21			0x21	// Reset PC in 10 Seconds
#define COMAND_0x24			0x24	// Arm Watchdog Now
#define COMAND_0x28			0x28	// Disable Watchdog
#define COMAND_0x29			0x29	// Enable Watchdog
#define COMAND_0x30			0x30	// Firmware	Major Rev
#define COMAND_0x31			0x31	// Firmware Minor Rev
#define COMAND_0x34			0x34	// No Operation
#define COMAND_0x38			0x38	// Get Reset Count
#define COMAND_0x39			0x39	// Clear Reset Count & LED
#define COMAND_0x40			0x40	// Turn Off AC Power Module
#define COMAND_0x41			0x41	// Turn On AC Power Module

class CExternalSerialWatchdog  
{
public:
	CExternalSerialWatchdog();
	virtual ~CExternalSerialWatchdog();

	CSerialPort& GetPcPort();
	void SetPcPort(const CSerialPort& pSerialPort);

	void SetCommand(const int& iCommand);
	void SendCommand();
	void InitializeSerialPort(	int iComPort,
								DWORD dwBaudRate,
								CSerialPort::Parity Parity,
								BYTE DataBits,
								CSerialPort::StopBits StopBits,
								CSerialPort::FlowControl FlowControl,
								int iInQueue,
								int iOutQueue);
	void CloseSerialConnection();

protected:
	CSerialPort*	m_pSerialPort;
	unsigned char	m_cCommand[5];
	CString			m_sResponse;


};

#endif // !defined(AFX_CEXTERNALSERIALWATCHDOG_H__759C8142_BD2A_41BB_92B9_9C508586AF07__INCLUDED_)
