// CExternalSerialWatchdog.cpp: implementation of the CExternalSerialWatchdog class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "CApplicationException.h"

#include "CExternalSerialWatchdog.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CExternalSerialWatchdog::CExternalSerialWatchdog():
m_pSerialPort(new CSerialPort)
{
	// see External Serial PC Watchdog documentation
	m_cCommand[0] = 0x01;	// fixed
	m_cCommand[1] = 0x57;	// fixed
	m_cCommand[2] = 0x84;	// fixed
	m_cCommand[3] = 0x00;	// command byte
	m_cCommand[4] = 0x00;	// simple checksum
}

CExternalSerialWatchdog::~CExternalSerialWatchdog()
{
	CloseSerialConnection();
	delete m_pSerialPort;
}

void CExternalSerialWatchdog::InitializeSerialPort(	int iComPort,
													DWORD dwBaudRate,
													CSerialPort::Parity Parity,
													BYTE DataBits,
													CSerialPort::StopBits StopBits,
													CSerialPort::FlowControl FlowControl,
													int iInQueue,
													int iOutQueue)
{
    // Setup the serial port as required.
	if (!m_pSerialPort->IsOpen())
	{
		// The Watchdog requires that the COM port on the PC be set to:
		// 1200 Baund, 8 Data Bits, No Parity Bit, and 2 Stop Bits
		if(m_pSerialPort->Open(	iComPort,
								dwBaudRate,
								Parity,
								DataBits,
								StopBits,
								FlowControl) == TRUE)
		{
			HANDLE hPort = m_pSerialPort->Detach();
			m_pSerialPort->Attach(hPort);

			m_pSerialPort->Setup(iInQueue, iOutQueue);
			m_pSerialPort->Set0WriteTimeout();
			m_pSerialPort->Set0ReadTimeout();
		}
		else
		{
			// Abnormal condition, something is wrong
			CSerialException* pSerialPortEx = new CSerialException(::GetLastError());
			throw (pSerialPortEx);
		};
	}
};

void CExternalSerialWatchdog::CloseSerialConnection()
{
	m_pSerialPort->ClearWriteBuffer();
	m_pSerialPort->ClearReadBuffer();
    
	if (m_pSerialPort->Flush() == FALSE)
	{
		// Abnormal condition, something is wrong
		CSerialException* pSerialPortEx = new CSerialException(::GetLastError());
		throw (pSerialPortEx);
	};

	m_pSerialPort->Close();
}

void CExternalSerialWatchdog::SetCommand(const int& iCommand)
{
	int i;
	unsigned char b;

	m_cCommand[3] = iCommand;

	for (i=0, b=0; i<4; i++)	// compute checksum
		b += m_cCommand[i];

	m_cCommand[4] = (0-b);
};

void CExternalSerialWatchdog::SendCommand()
{
    // The serial port is now ready and we can send/receive data.
	if (m_cCommand[3] != 0)
	{
		if (m_pSerialPort->IsOpen()) 
		{
			// The serial port is now ready and we can send/receive data.

			// Send command
			m_pSerialPort->Write(m_cCommand, 5);
		}
		else
		{
			int TODO_no_hard_text;
			// Abnormal condition, something is wrong.
			CApplicationException* pApplicationEx = new CApplicationException("Port no initialized");
			throw (pApplicationEx);
		}
	}
	else
	{
		int TODO_no_hard_text;
		// Abnormal condition, something is wrong.
		CApplicationException* pApplicationEx = new CApplicationException("Invalid Configuration");
		throw (pApplicationEx);
	}
};
