/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.webservices.urlmanager;

import com.mathworks.webservices.urlmanager.MissingPropertiesFileException;
import com.mathworks.webservices.urlmanager.MissingUrlKeyException;
import com.mathworks.webservices.urlmanager.ReleaseEnv;
import com.mathworks.webservices.urlmanager.ReleaseEnvSystemProperties;
import com.mathworks.webservices.urlmanager.UrlManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Properties;

class UrlManagerImpl
extends UrlManager {
    private static final String OVERRIDE_FILE_PROPERTY = "WS_OVERRIDE_FILE";
    private final ReleaseEnv releaseEnv;

    public UrlManagerImpl(ReleaseEnv env) {
        this.releaseEnv = env;
        this.setupUrlMap();
    }

    public UrlManagerImpl() {
        this(new ReleaseEnvSystemProperties());
    }

    @Override
    public String getUrl(String serviceName, boolean refreshUrlMap) {
        String rval;
        if (refreshUrlMap) {
            this.setupUrlMap();
        }
        if (null == (rval = this.urlMap.getProperty(serviceName))) {
            throw new MissingUrlKeyException(serviceName);
        }
        return rval.trim();
    }

    @Override
    public String getUrl(String serviceName) {
        return this.getUrl(serviceName, false);
    }

    @Override
    public List<String> getUrlList(String baseServiceName) {
        return this.getUrlList(baseServiceName, false);
    }

    @Override
    public List<String> getUrlList(String baseServiceName, boolean refreshMap) {
        ArrayList<String> rval = new ArrayList<String>(Arrays.asList(this.getUrl(baseServiceName, refreshMap)));
        int ii = 1;
        while (true) {
            String serviceName = MessageFormat.format("{0}.{1}", baseServiceName, ii);
            try {
                String serviceUrl = this.getUrl(serviceName, false);
                rval.add(serviceUrl);
            }
            catch (MissingUrlKeyException ignore) {
                break;
            }
            ++ii;
        }
        return rval;
    }

    final void setupUrlMap() {
        String env = this.releaseEnv.getReleaseEnvironment();
        String release = this.releaseEnv.getMatlabRelease();
        env = this.mapEnv(release, env);
        this.urlMap = this.loadPropertiesFile(release, env);
    }

    final String mapEnv(String release, String env) {
        if ("integ".equals(env)) {
            if (null == release) {
                throw new MissingResourceException("Release needed for integ environment", UrlManagerImpl.class.getSimpleName(), env);
            }
            String integProperties = this.getJarPropertiesFileName(env);
            Properties props = this.loadPropertiesFile(integProperties);
            if ((env = props.getProperty(release)) == null) {
                throw new MissingResourceException("No integration environment found for release", UrlManagerImpl.class.getSimpleName(), release);
            }
        }
        return env;
    }

    final Properties loadPropertiesFile(String release, String env) {
        List<String> searchPath = this.getPropertyFileSearchPath(release, env);
        Collections.reverse(searchPath);
        InputStream inputStream = null;
        Properties rval = null;
        for (String name : searchPath) {
            inputStream = this.getInputStreamForFileOrResource(name);
            if (null == inputStream) continue;
            rval = this.loadPropertiesFromStream(inputStream, rval);
        }
        if (null == rval) {
            throw new MissingPropertiesFileException(release, env);
        }
        return rval;
    }

    final Properties loadPropertiesFile(String fileName) {
        InputStream inputStream = UrlManagerImpl.class.getClassLoader().getResourceAsStream(fileName);
        if (null == inputStream) {
            throw new MissingResourceException("No url properties found", UrlManagerImpl.class.getSimpleName(), fileName);
        }
        return this.loadPropertiesFromStream(inputStream);
    }

    final Properties loadPropertiesFromStream(InputStream inputStream) {
        return this.loadPropertiesFromStream(inputStream, null);
    }

    final Properties loadPropertiesFromStream(InputStream inputStream, Properties defaults) {
        Properties props = new Properties(defaults);
        try {
            props.load(inputStream);
        }
        catch (Exception e) {
            throw new MissingResourceException("No such resource found", UrlManagerImpl.class.getSimpleName(), "");
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception e) {}
        }
        return props;
    }

    final List<String> getPropertyFileSearchPath(String release, String env) {
        ArrayList<String> rval = new ArrayList<String>();
        String override = System.getenv(OVERRIDE_FILE_PROPERTY);
        if (null == override && null != (override = System.getProperty(OVERRIDE_FILE_PROPERTY))) {
            rval.add(override);
        }
        String home = System.getenv("HOME");
        String homeProperties = MessageFormat.format("{0}/{1}.properties", home, env);
        rval.add(homeProperties);
        rval.addAll(this.releaseEnv.getSearchPath());
        rval.add(this.getJarPropertiesFileName(env));
        return rval;
    }

    final String getJarPropertiesFileName(String env) {
        return MessageFormat.format("com/mathworks/webservices/urlmanager/{0}.properties", env);
    }

    final InputStream getInputStreamForFileOrResource(String name) {
        InputStream inputStream = null;
        if (null == name || 0 == name.length()) {
            return inputStream;
        }
        File file = new File(name);
        try {
            inputStream = new FileInputStream(file);
        }
        catch (Exception ignore) {
            try {
                inputStream = UrlManagerImpl.class.getClassLoader().getResourceAsStream(name);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return inputStream;
    }
}

