/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.webservices.urlmanager;

import com.mathworks.webservices.urlmanager.ReleaseEnv;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Properties;

class ReleaseEnvImpl
implements ReleaseEnv {
    private static final String RELEASE_PROPERTY = "releasefamily";
    private static final String ENVIRONMENT_PROPERTY = "urlenv";
    private static final String ENVIRONMENT_OVERRIDE_PROPERTY = "WS_ENV";
    private final String matlabRelease;
    private final String environment;

    ReleaseEnvImpl(String releaseName, String releaseEnv) {
        this.matlabRelease = releaseName;
        if (null == this.matlabRelease) {
            throw new MissingResourceException("Properties file must contain property releasefamily", ReleaseEnvImpl.class.getSimpleName(), RELEASE_PROPERTY);
        }
        String env = System.getenv(ENVIRONMENT_OVERRIDE_PROPERTY);
        env = env != null ? env : System.getProperty(ENVIRONMENT_OVERRIDE_PROPERTY);
        this.environment = env = env != null ? env : releaseEnv;
        if (null == this.environment) {
            throw new MissingResourceException("Environment must be set", ReleaseEnvImpl.class.getSimpleName(), ENVIRONMENT_PROPERTY);
        }
    }

    ReleaseEnvImpl(Properties props) throws MissingResourceException {
        this.matlabRelease = props.getProperty(RELEASE_PROPERTY);
        if (null == this.matlabRelease) {
            throw new MissingResourceException("Properties file must contain property releasefamily", ReleaseEnvImpl.class.getSimpleName(), RELEASE_PROPERTY);
        }
        String env = System.getenv(ENVIRONMENT_OVERRIDE_PROPERTY);
        env = env != null ? env : System.getProperty(ENVIRONMENT_OVERRIDE_PROPERTY);
        this.environment = env = env != null ? env : props.getProperty(ENVIRONMENT_PROPERTY);
        if (null == this.environment) {
            throw new MissingResourceException("Environment must be set", ReleaseEnvImpl.class.getSimpleName(), ENVIRONMENT_PROPERTY);
        }
    }

    @Override
    public String getMatlabRelease() {
        return this.matlabRelease;
    }

    @Override
    public String getReleaseEnvironment() {
        return this.environment;
    }

    @Override
    public List<String> getSearchPath() {
        String home = System.getenv("HOME");
        return Arrays.asList(MessageFormat.format("{0}/.matlab/{1}/{2}.properties", home, this.matlabRelease, this.environment));
    }
}

