/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.brsanthu.dataexporter.output.text;

import com.mathworks.brsanthu.dataexporter.AbstractDataWriter;
import com.mathworks.brsanthu.dataexporter.ExportOptions;
import com.mathworks.brsanthu.dataexporter.model.CellDetails;
import com.mathworks.brsanthu.dataexporter.model.HeaderCellDetails;
import com.mathworks.brsanthu.dataexporter.model.RowDetails;
import com.mathworks.brsanthu.dataexporter.output.text.TextExportOptions;
import java.io.OutputStream;
import java.io.Writer;

public class TextWriter
extends AbstractDataWriter {
    public TextWriter() {
        this(System.out);
    }

    public TextWriter(TextExportOptions options) {
        super((ExportOptions)options, System.out);
    }

    public TextWriter(TextExportOptions options, OutputStream out) {
        super((ExportOptions)options, out);
    }

    public TextWriter(OutputStream out) {
        super((ExportOptions)new TextExportOptions(), out);
    }

    public TextWriter(TextExportOptions options, Writer out) {
        super((ExportOptions)options, out);
    }

    public TextWriter(Writer out) {
        super((ExportOptions)new TextExportOptions(), out);
    }

    public TextExportOptions getTextExportOptions() {
        return (TextExportOptions)this.getOptions();
    }

    @Override
    public void writeHeaderCell(HeaderCellDetails headerCell) {
        this.writeCell(headerCell.getColumnIndex(), headerCell.getColumn().getTitle());
    }

    @Override
    public void beforeRow(RowDetails rowDetails) {
        this.println();
    }

    @Override
    public void writeRowCell(CellDetails cellDetails) {
        Object cellValue = cellDetails.getCellValue();
        this.writeCell(cellDetails.getColumnIndex(), cellValue == null ? "" : cellDetails.getColumn().format(cellDetails));
    }

    public void writeCell(int i, String cellValue) {
        String delimiter = this.getTextExportOptions().getDelimiter();
        if (i != 0) {
            this.print(delimiter);
        }
        this.print(cellValue);
    }
}

