/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.brsanthu.dataexporter.model;

import com.mathworks.brsanthu.dataexporter.model.CellDetails;
import java.util.ArrayList;
import java.util.List;

public class Row {
    private List<Object> cells = new ArrayList<Object>();
    private List<Row> children = null;

    public Row() {
    }

    public Row(Object ... rowValues) {
        this.add(rowValues);
    }

    public Row(List<? extends Object> rowValues) {
        if (rowValues == null) {
            throw new IllegalArgumentException("Parameter rowValues cannot be null");
        }
        for (Object object : rowValues) {
            this.add(object);
        }
    }

    public Row add(Object ... rowValues) {
        if (rowValues == null) {
            throw new IllegalArgumentException("Parameter rowValues cannot be null");
        }
        for (Object value : rowValues) {
            this.cells.add(value);
        }
        return this;
    }

    public Object getCellValue(CellDetails cellDetails) {
        return this.cells.get(cellDetails.getColumnIndex());
    }

    public Object getCellValue(int index) {
        return this.cells.get(index);
    }

    public void setCellValue(int index, Object value) {
        this.cells.set(index, value);
    }

    public void addCellValue(Object value) {
        this.cells.add(value);
    }

    public void clearCellValues() {
        this.cells = new ArrayList<Object>();
    }

    public void setCellValues(List<Object> cells) {
        this.cells = cells;
    }

    public List<Object> getCellValues() {
        return this.cells;
    }

    public List<Row> getChildren() {
        return this.children;
    }

    public void setChildren(List<Row> children) {
        this.children = children;
    }

    public void addChild(Row child) {
        if (this.children == null) {
            this.children = new ArrayList<Row>();
        }
        this.children.add(child);
    }
}

