/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.brsanthu.dataexporter;

import com.mathworks.brsanthu.dataexporter.LineSeparatorType;
import com.mathworks.brsanthu.dataexporter.util.Util;

public class ExportOptions {
    private LineSeparatorType lineSeparator = LineSeparatorType.NATIVE;
    private boolean printHeaders = true;
    private boolean escapeHtml = false;
    private String nullString = "";

    public String getNullString() {
        return this.nullString;
    }

    public ExportOptions setNullString(String nullString) {
        Util.checkForNotNull(nullString, "nullString");
        this.nullString = nullString;
        return this;
    }

    public boolean isEscapeHtml() {
        return this.escapeHtml;
    }

    public ExportOptions setEscapeHtml(boolean escapeHtml) {
        this.escapeHtml = escapeHtml;
        return this;
    }

    public boolean isPrintHeaders() {
        return this.printHeaders;
    }

    public ExportOptions setPrintHeaders(boolean printHeaders) {
        this.printHeaders = printHeaders;
        return this;
    }

    public LineSeparatorType getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(LineSeparatorType lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public String getLineSeparatorString() {
        switch (this.lineSeparator) {
            case UNIX: {
                return "\n";
            }
            case WINDOWS: {
                return "\r\n";
            }
        }
        String separator = System.getProperty("line.separator");
        if (separator == null) {
            separator = "\r\n";
        }
        return separator;
    }
}

