/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard.ui.silent;

import com.google.inject.Inject;
import com.mathworks.instutil.logging.AppLogger;
import com.mathworks.wizard.command.Command;
import com.mathworks.wizard.ui.MessageType;
import com.mathworks.wizard.ui.OptionType;
import com.mathworks.wizard.ui.Response;
import com.mathworks.wizard.ui.WizardUI;
import java.awt.Component;
import java.awt.Image;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;

final class SilentWizardUI
implements WizardUI {
    private final AppLogger appLogger;

    @Inject
    SilentWizardUI(AppLogger appLogger) {
        this.appLogger = appLogger;
    }

    @Override
    public void showErrorMessage(String string, String string2) {
        this.appLogger.logMsg("Error: " + string2);
    }

    @Override
    public boolean getResponseToYesNoQuestion(String string, String string2, MessageType messageType) {
        return this.getResponseToQuestion(string, string2, messageType, OptionType.YES_NO).equals((Object)Response.YES);
    }

    @Override
    public Response getResponseToQuestion(String string, String string2, MessageType messageType, OptionType optionType) {
        this.appLogger.logMsg(string2);
        return MessageType.ERROR.equals((Object)messageType) ? Response.CANCEL : optionType.getDefaultResponse();
    }

    @Override
    public void setTitle(String string) {
    }

    @Override
    public boolean showWarningMessage(String string, String string2) {
        this.appLogger.logMsg("Warning: " + string2);
        return true;
    }

    @Override
    public void showInfoMessage(String string, Component component) {
    }

    @Override
    public boolean showPlainMessage(String string, Component component) {
        return true;
    }

    @Override
    public void showPanel(JPanel jPanel, String string, JPanel jPanel2, JButton jButton, Command command, String string2, String string3) {
    }

    @Override
    public boolean showMessageWithoutHidingProgressDialog(String string, Component component) {
        return true;
    }

    @Override
    public void setIconImages(List<Image> list) {
    }

    @Override
    public void closeAndDispose() {
    }

    @Override
    public void showProgress(String string, String string2, Command command) {
        this.appLogger.logMsg(string2);
    }

    @Override
    public void hideProgress() {
    }

    @Override
    public void showBusyCursor(Command command) {
    }

    @Override
    public void hideBusyCursor() {
    }
}

