/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard.ui.panels;

import com.mathworks.wizard.ResourceRetriever;
import com.mathworks.wizard.resources.WizardComponentName;
import com.mathworks.wizard.resources.WizardResourceKeys;
import com.mathworks.wizard.ui.components.SwingComponentFactory;
import com.mathworks.wizard.ui.panels.AbstractPanelUI;
import com.mathworks.wizard.ui.panels.PanelBuilder;
import java.awt.Font;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.text.html.HTMLDocument;

public class TrialsWelcomePanelUI
extends AbstractPanelUI {
    private static final String SEP = System.getProperty("line.separator");
    private final ResourceRetriever resourceRetriever;
    private final JPanel panel;

    TrialsWelcomePanelUI(ResourceRetriever resourceRetriever, SwingComponentFactory swingComponentFactory, PanelBuilder panelBuilder, ResourceBundle resourceBundle, Collection<String> collection) {
        super(resourceBundle, swingComponentFactory, resourceRetriever.getResource(WizardResourceKeys.WELCOME_TITLE, resourceRetriever.getResource(WizardResourceKeys.PRODUCT_NAME, new Object[0])));
        this.resourceRetriever = resourceRetriever;
        StringBuilder stringBuilder = new StringBuilder();
        for (String object2 : collection) {
            stringBuilder.append(SEP);
            stringBuilder.append(object2);
        }
        JComponent jComponent = swingComponentFactory.createLabel(WizardResourceKeys.WELCOME_LABEL_TRIALS_TEXT.getString(resourceRetriever, stringBuilder.toString()), WizardComponentName.WELCOME_LABEL_TRIALS_TEXT);
        panelBuilder.addRow(new JComponent[]{jComponent});
        panelBuilder.addRow(new JComponent[]{swingComponentFactory.createLabel("", WizardComponentName.EMPTY_COMPONENT)});
        panelBuilder.addVerticalFillRow(new JComponent[0]);
        JEditorPane jEditorPane = (JEditorPane)swingComponentFactory.createLabel(this.getTrademarksAndPatentsText(), WizardComponentName.WELCOME_FOOTER);
        Font font = jEditorPane.getFont();
        String string = "body { font-family: " + font.getFamily() + "; " + "font-size: " + ((float)font.getSize() - 2.0f) + "pt; }";
        ((HTMLDocument)jEditorPane.getDocument()).getStyleSheet().addRule(string);
        panelBuilder.addRow(new JComponent[]{jEditorPane});
        this.panel = panelBuilder.buildPanel();
    }

    private String getTrademarksAndPatentsText() {
        return WizardResourceKeys.WELCOME_TEXT_PROFESSIONAL.getString(this.resourceRetriever, new Object[0]) + SEP + SEP + WizardResourceKeys.TRADEMARK.getString(new Object[0]);
    }

    @Override
    public JComponent getInitialFocus(JComponent jComponent) {
        return jComponent;
    }

    @Override
    public String getAccessibleName() {
        return this.resourceRetriever.getResource(WizardResourceKeys.WELCOME_TITLE, this.resourceRetriever.getResource(WizardResourceKeys.PRODUCT_NAME, new Object[0]));
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    @Override
    public void configureBackButton(AbstractButton abstractButton) {
        abstractButton.setEnabled(false);
    }
}

