/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard.ui.panels;

import com.mathworks.wizard.command.Command;
import com.mathworks.wizard.model.BackgroundTask;
import com.mathworks.wizard.model.TaskStatusObserver;
import com.mathworks.wizard.resources.WizardComponentName;
import com.mathworks.wizard.resources.WizardResourceKeys;
import com.mathworks.wizard.ui.AllButtonProperties;
import com.mathworks.wizard.ui.WizardUI;
import com.mathworks.wizard.ui.components.ButtonFactory;
import com.mathworks.wizard.ui.components.SwingComponentFactory;
import com.mathworks.wizard.ui.panels.AbstractPanelUI;
import com.mathworks.wizard.ui.panels.PanelBuilder;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

class StatusPanelUI
extends AbstractPanelUI {
    private final JPanel panel;
    private final BackgroundTask task;
    private final JButton pauseResumeButton;
    private final JProgressBar progressBar;
    private final JTextComponent overallStatusLabel;
    private final JTextComponent currentStatusLabel;
    private final JTextComponent statusDetailsLabel;
    private String title = this.getTitle();
    private final WizardUI ui;

    StatusPanelUI(ResourceBundle resourceBundle, SwingComponentFactory swingComponentFactory, PanelBuilder panelBuilder, BackgroundTask backgroundTask, WizardUI wizardUI, boolean bl) {
        super(resourceBundle, swingComponentFactory, WizardResourceKeys.STATUS_TITLE.getString(new Object[0]));
        this.ui = wizardUI;
        this.task = backgroundTask;
        this.progressBar = swingComponentFactory.createProgressBar();
        this.overallStatusLabel = swingComponentFactory.createEditableLabel(WizardComponentName.STATUS_OVERALL_LABEL);
        this.currentStatusLabel = swingComponentFactory.createEditableLabel(WizardComponentName.STATUS_CURRENT_LABEL);
        this.statusDetailsLabel = swingComponentFactory.createNonWrappingNonAccessibleEditableLabel(WizardComponentName.STATUS_DETAILS_LABEL);
        ButtonFactory buttonFactory = swingComponentFactory.createButtonFactory(AllButtonProperties.PAUSE, AllButtonProperties.RESUME);
        this.pauseResumeButton = buttonFactory.createButton(AllButtonProperties.PAUSE, new PauseResumeAction(), WizardComponentName.STATUS_PAUSE_RESUME_BUTTON);
        ((PanelBuilder)((PanelBuilder)((PanelBuilder)((PanelBuilder)((PanelBuilder)panelBuilder.addRow(new JComponent[]{this.overallStatusLabel})).addLeftWeightedRow(new JComponent[]{this.currentStatusLabel})).addRow(new JComponent[]{this.progressBar})).addRow(new JComponent[]{this.statusDetailsLabel})).addRightAnchoredRow(new JComponent[]{this.pauseResumeButton})).addVerticalFillRow(new JComponent[0]);
        this.panel = bl ? panelBuilder.buildPanel() : panelBuilder.buildImagelessPanel();
        this.task.addStatusObserver(new MyTaskStatusObserver());
    }

    @Override
    public JComponent getInitialFocus(JComponent jComponent) {
        return this.pauseResumeButton;
    }

    @Override
    public String getAccessibleName() {
        return this.task.getAccessibleName();
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    @Override
    public void configureHelpButton(AbstractButton abstractButton) {
        abstractButton.setVisible(false);
    }

    @Override
    public void configureNextButton(AbstractButton abstractButton) {
        abstractButton.setVisible(false);
    }

    @Override
    public void configureBackButton(AbstractButton abstractButton) {
        abstractButton.setVisible(false);
    }

    private static void doOnEDT(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private class MyTaskStatusObserver
    implements TaskStatusObserver {
        private MyTaskStatusObserver() {
        }

        @Override
        public void updateOverallStatus(final String string) {
            StatusPanelUI.doOnEDT(new Runnable(){

                @Override
                public void run() {
                    StatusPanelUI.this.overallStatusLabel.setText(string);
                }
            });
        }

        @Override
        public void updateCurrentStatus(final String string) {
            StatusPanelUI.doOnEDT(new Runnable(){

                @Override
                public void run() {
                    StatusPanelUI.this.currentStatusLabel.setText(string);
                }
            });
        }

        @Override
        public void updateStatusDetails(final String string) {
            StatusPanelUI.doOnEDT(new Runnable(){

                @Override
                public void run() {
                    StatusPanelUI.this.statusDetailsLabel.setText(string);
                }
            });
        }

        @Override
        public void updatePercentComplete(final int n) {
            StatusPanelUI.this.title = MessageFormat.format(StatusPanelUI.this.getString("status.title1"), n);
            StatusPanelUI.doOnEDT(new Runnable(){

                @Override
                public void run() {
                    StatusPanelUI.this.progressBar.setValue(n);
                }
            });
            StatusPanelUI.this.ui.setTitle(StatusPanelUI.this.title);
        }
    }

    private final class PauseResumeAction
    extends AbstractAction {
        private Command cmd = new PauseCommand();

        PauseResumeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.cmd.execute();
        }

        private final class ResumeCommand
        implements Command {
            private ResumeCommand() {
            }

            @Override
            public void execute() {
                StatusPanelUI.this.task.resume();
                StatusPanelUI.this.factory.setButtonProperties(StatusPanelUI.this.pauseResumeButton, AllButtonProperties.PAUSE);
                PauseResumeAction.this.cmd = new PauseCommand();
            }
        }

        private final class PauseCommand
        implements Command {
            private PauseCommand() {
            }

            @Override
            public void execute() {
                StatusPanelUI.this.task.pause();
                StatusPanelUI.this.factory.setButtonProperties(StatusPanelUI.this.pauseResumeButton, AllButtonProperties.RESUME);
                PauseResumeAction.this.cmd = new ResumeCommand();
            }
        }
    }
}

