/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard.ui.panels;

import com.mathworks.wizard.model.ProductModel;
import com.mathworks.wizard.model.ProductTableFormat;
import com.mathworks.wizard.resources.WizardComponentName;
import com.mathworks.wizard.resources.WizardResourceKeys;
import com.mathworks.wizard.ui.components.SwingComponentFactory;
import com.mathworks.wizard.ui.components.TableProvider;
import com.mathworks.wizard.ui.panels.AbstractPanelUI;
import com.mathworks.wizard.ui.panels.PanelBuilder;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class ProductSelectionPanelUI<T>
extends AbstractPanelUI {
    private ProductModel<T> prodModel;
    private TableProvider productTableProvider;
    private final JPanel panel;

    ProductSelectionPanelUI(ResourceBundle resourceBundle, SwingComponentFactory swingComponentFactory, PanelBuilder panelBuilder, ProductModel<T> productModel, ProductTableFormat<T> productTableFormat, String string) {
        super(resourceBundle, swingComponentFactory, WizardResourceKeys.PRODUCTSELECTION_TITLE.getString(new Object[0]));
        this.prodModel = productModel;
        JComponent jComponent = swingComponentFactory.createLabel(string, WizardComponentName.PRODUCTSELECTION_LABEL_TOP);
        this.productTableProvider = swingComponentFactory.createProductTable(productModel, productTableFormat, new TableModelListener[0]);
        ((PanelBuilder)panelBuilder.addRow(new JComponent[]{jComponent})).addVerticalFillRow(new JComponent[]{this.productTableProvider.getComponent()});
        this.panel = panelBuilder.buildPanel();
    }

    @Override
    public JComponent getInitialFocus(JComponent jComponent) {
        if (jComponent.isEnabled()) {
            return jComponent;
        }
        return this.productTableProvider.getFocusableComponent();
    }

    @Override
    public String getAccessibleName() {
        return WizardResourceKeys.PRODUCTSELECTION_ACCESSIBLE.getString(new Object[0]);
    }

    @Override
    public void configureNextButton(final AbstractButton abstractButton) {
        abstractButton.setEnabled(this.prodModel.anySelected());
        this.productTableProvider.getTableModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                abstractButton.setEnabled(ProductSelectionPanelUI.this.prodModel.anySelected());
            }
        });
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }
}

