/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard.ui.panels;

import com.google.inject.Inject;
import com.mathworks.install.udc.UdcUtil;
import com.mathworks.install.udc.UsageDataCollector;
import com.mathworks.instutil.AvailablePlatform;
import com.mathworks.instutil.FolderUtils;
import com.mathworks.instutil.Platform;
import com.mathworks.net.hyperlink.HyperlinkProvider;
import com.mathworks.wizard.ResourceRetriever;
import com.mathworks.wizard.SourcePathProvider;
import com.mathworks.wizard.Step;
import com.mathworks.wizard.command.NoOpStep;
import com.mathworks.wizard.model.AccessibleTableFormat;
import com.mathworks.wizard.model.BackgroundTask;
import com.mathworks.wizard.model.ConnectionMode;
import com.mathworks.wizard.model.DefaultedModel;
import com.mathworks.wizard.model.FileSystem;
import com.mathworks.wizard.model.InstallOptionModel;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.model.OptionSelectedState;
import com.mathworks.wizard.model.PlatformModel;
import com.mathworks.wizard.model.ProductModel;
import com.mathworks.wizard.model.ProductTableFormat;
import com.mathworks.wizard.resources.WizardComponentName;
import com.mathworks.wizard.resources.WizardResourceKeys;
import com.mathworks.wizard.ui.AllButtonProperties;
import com.mathworks.wizard.ui.CheckBoxConfiguration;
import com.mathworks.wizard.ui.WizardUI;
import com.mathworks.wizard.ui.components.SwingComponentFactory;
import com.mathworks.wizard.ui.help.Help;
import com.mathworks.wizard.ui.panels.AbstractNextStepsPanelUI;
import com.mathworks.wizard.ui.panels.ActivateFinalPanelUI;
import com.mathworks.wizard.ui.panels.ActivationKeyPanelUI;
import com.mathworks.wizard.ui.panels.AddonsUninstallStatusPanelUI;
import com.mathworks.wizard.ui.panels.ConfirmationPanelUI;
import com.mathworks.wizard.ui.panels.CreateAccountPanelUI;
import com.mathworks.wizard.ui.panels.DefaultFinalPanelUI;
import com.mathworks.wizard.ui.panels.DefaultNextStepsPanelUI;
import com.mathworks.wizard.ui.panels.DownloadFinalPanelUI;
import com.mathworks.wizard.ui.panels.DownloadFolderSelectionPanelUI;
import com.mathworks.wizard.ui.panels.DownloadInstallPanelUI;
import com.mathworks.wizard.ui.panels.EmailVerificationPanelUI;
import com.mathworks.wizard.ui.panels.EntitlementSelectionPanelUI;
import com.mathworks.wizard.ui.panels.FikPanelUI;
import com.mathworks.wizard.ui.panels.FolderSelectionPanelUI;
import com.mathworks.wizard.ui.panels.InstallAgentFinalPanelUI;
import com.mathworks.wizard.ui.panels.InstallAgentWelcomePanelUI;
import com.mathworks.wizard.ui.panels.LicenseAgreementPanelUI;
import com.mathworks.wizard.ui.panels.LicenseFilePanelUI;
import com.mathworks.wizard.ui.panels.LinuxOptionsPanelUI;
import com.mathworks.wizard.ui.panels.LoginPanelUI;
import com.mathworks.wizard.ui.panels.MCRAlreadyInstalledFolderSelectionPanelUI;
import com.mathworks.wizard.ui.panels.MCRNotInstalledFolderSelectionPanelUI;
import com.mathworks.wizard.ui.panels.MacOptionsPanelUI;
import com.mathworks.wizard.ui.panels.NotesPanelUI;
import com.mathworks.wizard.ui.panels.PanelBuilder;
import com.mathworks.wizard.ui.panels.PanelStepBuilder;
import com.mathworks.wizard.ui.panels.PanelStepFactory;
import com.mathworks.wizard.ui.panels.PanelUI;
import com.mathworks.wizard.ui.panels.PrintableNextStepsPanelUI;
import com.mathworks.wizard.ui.panels.ProductSelectionPanelUI;
import com.mathworks.wizard.ui.panels.ProxyConfigurator;
import com.mathworks.wizard.ui.panels.StatusPanelUI;
import com.mathworks.wizard.ui.panels.TrialsFinalPanelUI;
import com.mathworks.wizard.ui.panels.TrialsWelcomePanelUI;
import com.mathworks.wizard.ui.panels.TypicalCustomPanelUI;
import com.mathworks.wizard.ui.panels.UninstallAddOnWelcomePanelUI;
import com.mathworks.wizard.ui.panels.UninstallerFinishPanelUI;
import com.mathworks.wizard.ui.panels.UninstallerProductSelectionPanelUI;
import com.mathworks.wizard.ui.panels.WelcomePanelUI;
import com.mathworks.wizard.ui.panels.WindowsLicenseManagerConfigPanelUI;
import com.mathworks.wizard.ui.panels.WindowsOptionsPanelUI;
import java.awt.Component;
import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;

final class PanelStepBuilderImpl
implements PanelStepBuilder {
    private final PanelStepFactory pnlStepFactory;
    private final ResourceBundle bundle;
    private final Help hlp;
    private final SwingComponentFactory scf;
    private final PanelBuilder pnlBuilder;
    private final SourcePathProvider srcPathProvider;
    private final Platform platform;
    private final WizardUI ui;
    private final FolderUtils folderUtils;
    private final ProxyConfigurator proxyConfig;
    private final ResourceRetriever resourceRetriever;
    private final HyperlinkProvider hyperlinkProvider;
    private final UsageDataCollector usageDataCollector;

    @Inject
    PanelStepBuilderImpl(PanelStepFactory panelStepFactory, ResourceBundle resourceBundle, Help help, SwingComponentFactory swingComponentFactory, PanelBuilder panelBuilder, SourcePathProvider sourcePathProvider, WizardUI wizardUI, Platform platform, FolderUtils folderUtils, ProxyConfigurator proxyConfigurator, ResourceRetriever resourceRetriever, HyperlinkProvider hyperlinkProvider, UsageDataCollector usageDataCollector) {
        this.pnlStepFactory = panelStepFactory;
        this.bundle = resourceBundle;
        this.hlp = help;
        this.scf = swingComponentFactory;
        this.pnlBuilder = panelBuilder;
        this.srcPathProvider = sourcePathProvider;
        this.ui = wizardUI;
        this.platform = platform;
        this.folderUtils = folderUtils;
        this.proxyConfig = proxyConfigurator;
        this.resourceRetriever = resourceRetriever;
        this.hyperlinkProvider = hyperlinkProvider;
        this.usageDataCollector = usageDataCollector;
    }

    @Override
    public Step buildWelcomeStep(Model<ConnectionMode> model, Step step) {
        WelcomePanelUI welcomePanelUI = new WelcomePanelUI(this.bundle, this.scf, this.pnlBuilder, this.getActivateHelpURI(), this.ui, model, this.proxyConfig, step, this.resourceRetriever, this.hlp);
        return this.createPanelStep(welcomePanelUI, ConnectionMode.OFFLINE_ONLY.equals((Object)model.get()) ? WizardResourceKeys.HELP_WELCOME_OFFLINEONLY.getKey() : WizardResourceKeys.HELP_WELCOME.getKey(), true);
    }

    @Override
    public Step buildInstallAgentWelcomeStep(Step step, String string, String string2) {
        InstallAgentWelcomePanelUI installAgentWelcomePanelUI = new InstallAgentWelcomePanelUI(this.bundle, this.scf, this.pnlBuilder, this.ui, step, this.proxyConfig, string, string2);
        return this.createPanelStep(installAgentWelcomePanelUI, WizardResourceKeys.HELP_WELCOME_OFFLINEONLY.getKey(), false);
    }

    private URI getActivateHelpURI() {
        return this.getHelpURI("help.activate");
    }

    private URI getHelpURI(String string) {
        return this.hlp.getHelpURI(string);
    }

    @Override
    public Step buildLicenseAgreementStep(Model<Boolean> model, String string) {
        LicenseAgreementPanelUI licenseAgreementPanelUI = new LicenseAgreementPanelUI(this.bundle, this.scf, this.pnlBuilder, string, model, this.resourceRetriever);
        return this.createPanelStep(licenseAgreementPanelUI, "help.license");
    }

    @Override
    public Step buildFikStep(Model<Boolean> model, Model<String> model2) {
        FikPanelUI fikPanelUI = new FikPanelUI(this.bundle, this.scf, this.pnlBuilder, model, model2);
        return this.createPanelStep(fikPanelUI, "help.fik");
    }

    @Override
    public Step buildNextStepsStep(String string) {
        AbstractNextStepsPanelUI abstractNextStepsPanelUI = this.platform.isMac() ? new DefaultNextStepsPanelUI(this.bundle, this.scf, this.pnlBuilder, this.bundle.getString("label.user.nonwindows"), string, this.hyperlinkProvider) : (this.platform.isWindows() ? new PrintableNextStepsPanelUI(this.bundle, this.scf, this.pnlBuilder, this.bundle.getString("label.user.windows"), string, this.hyperlinkProvider) : new PrintableNextStepsPanelUI(this.bundle, this.scf, this.pnlBuilder, this.bundle.getString("label.user.nonwindows"), string, this.hyperlinkProvider));
        return this.createPanelStep(abstractNextStepsPanelUI, "help.offnetwork");
    }

    @Override
    public Step buildTypicalCustomStep(Model<Boolean> model, String string) {
        return this.createPanelStep(new TypicalCustomPanelUI(this.bundle, this.scf, this.pnlBuilder, model, string), "help.typicalcustom");
    }

    @Override
    public <T> Step buildProductSelectionStep(ProductModel<T> productModel, ProductTableFormat<T> productTableFormat) {
        return this.createProductSelectionStep(productModel, productTableFormat, this.bundle.getString("product.label.top"));
    }

    private <T> Step createProductSelectionStep(ProductModel<T> productModel, ProductTableFormat<T> productTableFormat, String string) {
        return this.createPanelStep(new ProductSelectionPanelUI<T>(this.bundle, this.scf, this.pnlBuilder, productModel, productTableFormat, string), "help.product");
    }

    @Override
    public <T> Step buildDownloadProductSelectionStep(ProductModel<T> productModel, ProductTableFormat<T> productTableFormat) {
        String string = this.bundle.getString("download.product.label.top");
        if (productModel.isAnyProductPreviouslyDownloaded()) {
            string = string + System.getProperty("line.separator") + System.getProperty("line.separator") + this.bundle.getString("download.products.already.installer");
        }
        return this.createProductSelectionStep(productModel, productTableFormat, string);
    }

    @Override
    public Step createMCRFolderSelectionPanelStep(DefaultedModel<String> defaultedModel, FileSystem fileSystem, ImageIcon imageIcon) {
        MCRNotInstalledFolderSelectionPanelUI mCRNotInstalledFolderSelectionPanelUI = new MCRNotInstalledFolderSelectionPanelUI(this.bundle, this.scf, this.pnlBuilder, this.folderUtils, defaultedModel, WizardResourceKeys.MCR_FOLDER_TITLE.getString(new Object[0]), this.resourceRetriever, WizardResourceKeys.INSTALL_FOLDER_FIELD_LABEL.getString(new Object[0]), imageIcon);
        return this.createPanelStep(mCRNotInstalledFolderSelectionPanelUI, "help.folder");
    }

    @Override
    public Step createMCRAlreadyInstalledPanelStep(ImageIcon imageIcon, Model<String> model, Model<Boolean> model2) {
        MCRAlreadyInstalledFolderSelectionPanelUI mCRAlreadyInstalledFolderSelectionPanelUI = new MCRAlreadyInstalledFolderSelectionPanelUI(this.bundle, this.scf, this.pnlBuilder, WizardResourceKeys.MCR_FOLDER_TITLE.getString(new Object[0]), this.resourceRetriever, imageIcon, model, model2);
        return this.createPanelStep(mCRAlreadyInstalledFolderSelectionPanelUI, "help.folder");
    }

    @Override
    public Step buildWindowsInstallationOptionsStep(InstallOptionModel installOptionModel, InstallOptionModel installOptionModel2) {
        if (installOptionModel != null && installOptionModel2 != null) {
            return this.createPanelStep(new WindowsOptionsPanelUI(this.bundle, this.scf, this.pnlBuilder, installOptionModel, installOptionModel2, this.usageDataCollector, this.platform), "help.options");
        }
        return new NoOpStep();
    }

    @Override
    public Step buildLinuxInstallationOptionsStep(InstallOptionModel installOptionModel) {
        if (installOptionModel != null) {
            return this.createPanelStep(new LinuxOptionsPanelUI(this.bundle, this.scf, this.pnlBuilder, this.folderUtils, installOptionModel, this.usageDataCollector, this.platform), "help.options");
        }
        return new NoOpStep();
    }

    @Override
    public Step buildMacInstallationOptionsStep() {
        if (UdcUtil.getInstance().isDdux()) {
            return this.createPanelStep(new MacOptionsPanelUI(this.bundle, this.scf, this.pnlBuilder, this.platform), "help.options");
        }
        return new NoOpStep();
    }

    @Override
    public Step buildConfirmationStep(String string) {
        return this.buildConfirmationStep(string, true);
    }

    @Override
    public Step buildConfirmationStep(String string, boolean bl) {
        return this.createPanelStep(new ConfirmationPanelUI(this.bundle, this.scf, this.pnlBuilder, string, AllButtonProperties.INSTALL), "help.confirm", bl);
    }

    @Override
    public Step buildDownloadConfirmationStep(String string) {
        return this.createPanelStep(new ConfirmationPanelUI(this.bundle, this.scf, this.pnlBuilder, string, AllButtonProperties.DOWNLOAD), "help.confirm.download");
    }

    @Override
    public Step buildFolderSelectionStep(DefaultedModel<String> defaultedModel) {
        FolderSelectionPanelUI folderSelectionPanelUI = new FolderSelectionPanelUI(this.bundle, this.scf, this.pnlBuilder, this.folderUtils, defaultedModel, WizardResourceKeys.FOLDER_TITLE.getString(new Object[0]), this.usageDataCollector, new JComponent[0]);
        return this.createPanelStep(folderSelectionPanelUI, "help.folder");
    }

    @Override
    public Step buildUserAppFolderSelectionStep(DefaultedModel<String> defaultedModel, FileSystem fileSystem, InstallOptionModel installOptionModel, boolean bl) {
        PanelUI panelUI = this.getUserAppFolderSelectionPanelUI(defaultedModel, installOptionModel);
        return this.createPanelStep(panelUI, "help.folder", bl);
    }

    private PanelUI getUserAppFolderSelectionPanelUI(DefaultedModel<String> defaultedModel, InstallOptionModel installOptionModel) {
        if (this.platform.isWindows()) {
            JPanel jPanel = this.createDesktopShortcutCheckbox(installOptionModel);
            return new FolderSelectionPanelUI(this.bundle, this.scf, this.pnlBuilder, this.folderUtils, defaultedModel, WizardResourceKeys.OPTIONS_TITLE.getString(new Object[0]), this.usageDataCollector, jPanel);
        }
        return new FolderSelectionPanelUI(this.bundle, this.scf, this.pnlBuilder, this.folderUtils, defaultedModel, WizardResourceKeys.OPTIONS_TITLE.getString(new Object[0]), this.usageDataCollector, new JComponent[0]);
    }

    private JPanel createDesktopShortcutCheckbox(InstallOptionModel installOptionModel) {
        String string = this.bundle.getString("userApp.desktop.shortcut");
        AbstractButton abstractButton = this.scf.createCheckBox(string, WizardComponentName.OPTIONS_DESKTOP_CB);
        this.scf.createAssociation(abstractButton, installOptionModel);
        JPanel jPanel = this.scf.createPanel();
        jPanel.add((Component)abstractButton, "North");
        return jPanel;
    }

    @Override
    public Step buildDownloadFolderSelectionStep(DefaultedModel<File> defaultedModel, PlatformModel<AvailablePlatform> platformModel) {
        DownloadFolderSelectionPanelUI downloadFolderSelectionPanelUI = new DownloadFolderSelectionPanelUI(this.bundle, this.scf, this.pnlBuilder, this.folderUtils, defaultedModel, platformModel, this.usageDataCollector);
        return this.createPanelStep(downloadFolderSelectionPanelUI, WizardResourceKeys.HELP_DOWNLOAD_FOLDER.getKey());
    }

    @Override
    public Step buildStatusStep(BackgroundTask backgroundTask, boolean bl) {
        return this.buildStatusStep(backgroundTask, bl, true);
    }

    @Override
    public Step buildStatusStep(BackgroundTask backgroundTask, boolean bl, boolean bl2) {
        return this.pnlStepFactory.createPanelStep((PanelUI)new StatusPanelUI(this.bundle, this.scf, this.pnlBuilder, backgroundTask, this.ui, bl), backgroundTask, bl2);
    }

    @Override
    public Step buildInstallAgentFinalPanel(String string) {
        return this.createPanelStep(new InstallAgentFinalPanelUI(this.bundle, this.scf, this.pnlBuilder, string), "help.folder", false);
    }

    @Override
    public Step buildTrialsWelcomePanelStep(Collection<String> collection) {
        return this.createPanelStep(new TrialsWelcomePanelUI(this.resourceRetriever, this.scf, this.pnlBuilder, this.bundle, collection));
    }

    @Override
    public Step buildTrialsFinalPanelStep(Model<CheckBoxConfiguration> model) {
        return this.createPanelStep(new TrialsFinalPanelUI(this.bundle, this.scf, this.pnlBuilder, this.resourceRetriever, model));
    }

    @Override
    public Step buildAddOnsUninstallerWelcomePanelStep(Collection<String> collection) {
        return this.createPanelStep(new UninstallAddOnWelcomePanelUI(this.resourceRetriever, this.scf, this.pnlBuilder, this.bundle, collection));
    }

    @Override
    public Step buildAddOnsUninstallStatusStep(BackgroundTask backgroundTask) {
        return this.pnlStepFactory.createPanelStep(new AddonsUninstallStatusPanelUI(this.bundle, this.scf, this.pnlBuilder, backgroundTask, this.ui, true), backgroundTask, true, WizardResourceKeys.CANCEL_UNINSTALL_TEXT);
    }

    @Override
    public Step buildFinalPanelStep(Model<CheckBoxConfiguration> model, Model<CheckBoxConfiguration> model2, boolean bl, int n, String string) {
        if (CheckBoxConfiguration.NOT_VISIBLE.equals((Object)model.get())) {
            return this.createPanelStep(new DefaultFinalPanelUI(this.bundle, this.scf, this.pnlBuilder, bl, model2, n, string));
        }
        return this.createPanelStep(new ActivateFinalPanelUI(this.bundle, this.scf, this.pnlBuilder, this.getActivateHelpURI(), model, model2, n, string, bl, this.usageDataCollector));
    }

    @Override
    public Step buildDownloadFinalPanelStep(int n, String string, Model<CheckBoxConfiguration> model) {
        return this.createPanelStep(new DownloadFinalPanelUI(this.bundle, this.scf, this.pnlBuilder, n, string, model, this.usageDataCollector));
    }

    @Override
    public Step buildNotesStep(String string) {
        if (!"".equalsIgnoreCase(string)) {
            return this.createPanelStep(new NotesPanelUI(this.bundle, this.scf, this.pnlBuilder, string), "help.setup");
        }
        return new NoOpStep();
    }

    @Override
    public <T> Step buildUninstallerProductSelectionStep(ProductModel<T> productModel, ProductTableFormat<T> productTableFormat, Model<Boolean> model, InstallOptionModel ... installOptionModelArray) {
        return this.createPanelStep(new UninstallerProductSelectionPanelUI<T>(this.bundle, this.scf, this.pnlBuilder, productModel, productTableFormat, this.srcPathProvider, model, installOptionModelArray));
    }

    @Override
    public Step buildUninstallerFinishStep(Model<Boolean> model) {
        return this.createPanelStep(new UninstallerFinishPanelUI(this.bundle, this.scf, this.pnlBuilder, this.srcPathProvider, model));
    }

    @Override
    public Step buildLoginPanelStep(Model<String> model, Model<String> model2, Model<OptionSelectedState> model3) {
        return this.createPanelStep(new LoginPanelUI(this.bundle, this.scf, this.pnlBuilder, model, model2, model3, this.hyperlinkProvider), "help.login");
    }

    @Override
    public <T> Step buildEntitlementSelectionPanelStep(Model<T[]> model, Model<T> model2, AccessibleTableFormat<T> accessibleTableFormat, Model<Boolean> model3, Model<String> model4) {
        return this.createPanelStep(new EntitlementSelectionPanelUI<T>(this.bundle, this.scf, this.pnlBuilder, model, model2, accessibleTableFormat, model4, model3, this.getActivationKeyHelpURI()), WizardResourceKeys.HELP_ENTITLEMENT_SELECTION.getKey());
    }

    private URI getActivationKeyHelpURI() {
        return this.getHelpURI(WizardResourceKeys.HELP_ENTITLEMENT_SELECTION.getKey());
    }

    @Override
    public Step buildActivationKeyPanelStep(Model<String> model) {
        return this.createPanelStep(new ActivationKeyPanelUI(this.bundle, this.scf, this.pnlBuilder, model, this.getHelpURI(WizardResourceKeys.HELP_ACTIVATION_KEY.getKey())), WizardResourceKeys.HELP_ACTIVATION_KEY.getKey());
    }

    @Override
    public Step buildCreateAccountPanelStep(Model<String> model, Model<String> model2, Model<String> model3, Model<String> model4, Model<String> model5, Model<String> model6, Model<String> model7) {
        return this.createPanelStep(new CreateAccountPanelUI(this.bundle, this.scf, this.pnlBuilder, model, model2, model3, model4, model5, model6, model7), WizardResourceKeys.HELP_CREATE_ACCOUNT.getKey());
    }

    @Override
    public Step buildLicenseFilePanelStep(Model<String> model) {
        return this.createPanelStep(new LicenseFilePanelUI(this.bundle, this.scf, this.pnlBuilder, this.folderUtils, model), WizardResourceKeys.HELP_LICENSE_FILE.getKey());
    }

    @Override
    public Step buildLicenseServicePanelStep(InstallOptionModel installOptionModel, String string, File file, File file2) {
        if (this.platform.isWindows()) {
            return this.createPanelStep(new WindowsLicenseManagerConfigPanelUI(this.bundle, this.scf, this.pnlBuilder, installOptionModel, this.ui, string, file, file2, this.usageDataCollector), WizardResourceKeys.HELP_LICENSE_MANAGER_CONFIG.getKey());
        }
        return new NoOpStep();
    }

    @Override
    public Step buildVerifyEmailAddressPanelStep(Model<String> model, Model<String> model2) {
        return this.createPanelStep(new EmailVerificationPanelUI(this.bundle, this.scf, this.pnlBuilder), WizardResourceKeys.HELP_EMAIL_VERIFICATION.getKey());
    }

    @Override
    public Step buildDownloadInstallPanelStep(Model<Boolean> model) {
        DownloadInstallPanelUI downloadInstallPanelUI = new DownloadInstallPanelUI(this.bundle, this.scf, this.pnlBuilder, model, this.resourceRetriever);
        return this.createPanelStep(downloadInstallPanelUI, WizardResourceKeys.DOWNLOAD_INSTALL_HELP.getKey());
    }

    private Step createPanelStep(PanelUI panelUI) {
        return this.pnlStepFactory.createPanelStep(panelUI);
    }

    private Step createPanelStep(PanelUI panelUI, String string) {
        return this.createPanelStep(panelUI, string, true);
    }

    private Step createPanelStep(PanelUI panelUI, String string, boolean bl) {
        return this.pnlStepFactory.createPanelStep(panelUI, string, bl);
    }
}

