/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard.ui.panels;

import com.mathworks.wizard.WizardObserver;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.resources.WizardComponentName;
import com.mathworks.wizard.resources.WizardResourceKeys;
import com.mathworks.wizard.ui.components.SwingComponentFactory;
import com.mathworks.wizard.ui.panels.AbstractPanelUI;
import com.mathworks.wizard.ui.panels.PanelBuilder;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;

final class FikPanelUI
extends AbstractPanelUI {
    static final int MIN_FIK_LENGTH = 20;
    private final JPanel panel;
    private final AbstractButton fikButton;
    private final AbstractButton noFikButton;
    private final Model<Boolean> hasFik;
    private JTextComponent fikField;
    private Model<String> fikValue;

    FikPanelUI(ResourceBundle resourceBundle, SwingComponentFactory swingComponentFactory, PanelBuilder panelBuilder, Model<Boolean> model, Model<String> model2) {
        super(resourceBundle, swingComponentFactory, WizardResourceKeys.FIK_TITLE.getString(new Object[0]));
        this.hasFik = model;
        this.fikValue = model2;
        JComponent jComponent = swingComponentFactory.createLabel(WizardResourceKeys.FIK_BOLD.getString(new Object[0]), WizardComponentName.FIK_UPPER_TEXT);
        this.fikButton = swingComponentFactory.createRadioButton(resourceBundle.getString("fik.rb1"), WizardComponentName.FIK_RB1);
        this.fikButton.setSelected(this.hasFik.get());
        this.noFikButton = swingComponentFactory.createRadioButton(resourceBundle.getString("fik.rb2"), WizardComponentName.FIK_RB2);
        swingComponentFactory.createButtonGroup(this.fikButton, this.noFikButton);
        JComponent jComponent2 = swingComponentFactory.createLabel(resourceBundle.getString("fik.bottom"), WizardComponentName.FIK_LOWER_TEXT);
        this.fikField = swingComponentFactory.createFileInstallationKeyField(WizardComponentName.FIK_TEXTFIELD, resourceBundle.getString("fik.rb1"));
        this.fikField.setText(this.fikValue.get());
        swingComponentFactory.createRelationship(this.fikButton, this.fikField);
        ((PanelBuilder)((PanelBuilder)((PanelBuilder)((PanelBuilder)panelBuilder.addRow(new JComponent[]{jComponent})).addRow(new JComponent[]{this.fikButton})).addSubRow(new JComponent[]{this.fikField})).addRow(new JComponent[]{this.noFikButton})).addRow(new JComponent[]{jComponent2});
        this.panel = panelBuilder.buildPanel();
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    @Override
    public JComponent getInitialFocus(JComponent jComponent) {
        return this.fikButton;
    }

    @Override
    public String getAccessibleName() {
        return WizardResourceKeys.FIK_BOLD.getString(new Object[0]);
    }

    @Override
    public boolean apply() {
        this.hasFik.set(this.fikButton.isSelected());
        this.fikValue.set(this.fikField.getText());
        return true;
    }

    @Override
    public void configureNextButton(final AbstractButton abstractButton) {
        abstractButton.setEnabled(this.noFikButton.isSelected() || this.fikButtonSelectedAndFikExists());
        this.noFikButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                abstractButton.setEnabled(itemEvent.getStateChange() == 1);
            }
        });
        this.fikButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                abstractButton.setEnabled(itemEvent.getStateChange() == 1 && FikPanelUI.this.fikExists());
            }
        });
        this.factory.addDocumentObserver(this.fikField.getDocument(), new WizardObserver(){

            @Override
            public void update() {
                abstractButton.setEnabled(FikPanelUI.this.fikButtonSelectedAndFikExists());
            }
        });
    }

    private boolean fikButtonSelectedAndFikExists() {
        return this.fikButton.isSelected() && this.fikExists();
    }

    private boolean fikExists() {
        return this.fikField.getText().length() >= 20;
    }
}

