/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard.ui.panels;

import com.mathworks.wizard.WizardObserver;
import com.mathworks.wizard.model.AccessibleTableFormat;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.resources.WizardComponentName;
import com.mathworks.wizard.resources.WizardResourceKeys;
import com.mathworks.wizard.ui.components.SwingComponentFactory;
import com.mathworks.wizard.ui.components.TableProvider;
import com.mathworks.wizard.ui.panels.AbstractPanelUI;
import com.mathworks.wizard.ui.panels.PanelBuilder;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URI;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;

public final class EntitlementSelectionPanelUI<T>
extends AbstractPanelUI {
    private final JPanel panel;
    private final AbstractButton selectLicenseButton;
    private final TableProvider tableProvider;
    private final Model<T> selectedEntitlement;
    private final Model<String> activationKey;
    private final Model<Boolean> entitlementSwitch;
    private final JTextComponent activationKeyField;
    private final AbstractButton enterActivationKeyButton;

    EntitlementSelectionPanelUI(ResourceBundle resourceBundle, SwingComponentFactory swingComponentFactory, PanelBuilder panelBuilder, Model<T[]> model, Model<T> model2, AccessibleTableFormat<T> accessibleTableFormat, Model<String> model3, Model<Boolean> model4, URI uRI) {
        super(resourceBundle, swingComponentFactory, WizardResourceKeys.ENTITLEMENT_SELECTION_TITLE.getString(new Object[0]));
        this.selectedEntitlement = model2;
        this.activationKey = model3;
        this.entitlementSwitch = model4;
        JComponent jComponent = swingComponentFactory.createLabel(WizardResourceKeys.ENTITLEMENT_SELECTION_BOLD_LABEL.getString(new Object[0]), WizardComponentName.ENTITLEMENT_SELECTION_BOLD_LABEL);
        JComponent jComponent2 = swingComponentFactory.createLabel(WizardResourceKeys.ENTITLEMENT_SELECTION_SUB_LABEL.getString(new Object[0]), WizardComponentName.ENTITLEMENT_SELECTION_SUB_LABEL);
        this.selectLicenseButton = swingComponentFactory.createRadioButton(WizardResourceKeys.ENTITLEMENT_SELECTION_SELECT_LICENSE_BUTTON.getString(new Object[0]), WizardComponentName.ENTITLEMENT_SELECTION_SELECT_LICENSE_BUTTON);
        this.selectLicenseButton.setSelected(true);
        this.tableProvider = swingComponentFactory.createEntitlementTable(model, model2, accessibleTableFormat, new ListSelectionListener[0]);
        this.enterActivationKeyButton = swingComponentFactory.createRadioButton(WizardResourceKeys.ENTITLEMENT_SELECTION_ACTIVATION_KEY_BUTTON.getString(new Object[0]), WizardComponentName.ENTITLEMENT_SELECTION_ACTIVATION_KEY_BUTTON);
        this.activationKeyField = swingComponentFactory.createTextField(WizardComponentName.ENTITLEMENT_SELECTION_ACTIVATION_KEY_FIELD, WizardResourceKeys.ENTITLEMENT_SELECTION_ACTIVATION_KEY_BUTTON.getString(new Object[0]));
        JComponent jComponent3 = swingComponentFactory.createLabel(WizardResourceKeys.ENTITLEMENT_SELECTION_ACTIVATION_KEY_DESCRIPTION.getString(uRI), WizardComponentName.ENTITLEMENT_SELECTION_ACTIVATION_KEY_DESCRIPTION);
        swingComponentFactory.createButtonGroup(this.selectLicenseButton, this.enterActivationKeyButton);
        swingComponentFactory.createRelationship(this.selectLicenseButton, this.tableProvider.getComponent());
        swingComponentFactory.createRelationship(this.enterActivationKeyButton, this.activationKeyField);
        this.panel = ((PanelBuilder)((PanelBuilder)((PanelBuilder)((PanelBuilder)((PanelBuilder)((PanelBuilder)((PanelBuilder)panelBuilder.addRow(new JComponent[]{jComponent})).addRow(new JComponent[]{jComponent2})).addRow(new JComponent[]{this.selectLicenseButton})).addVerticalFillSubRow(new JComponent[]{this.tableProvider.getComponent()})).addRow(new JComponent[]{this.enterActivationKeyButton})).addSubRow(new JComponent[]{this.activationKeyField})).addSubRow(new JComponent[]{jComponent3})).buildPanel();
    }

    @Override
    public boolean apply() {
        if (this.selectLicenseButton.isSelected()) {
            this.entitlementSwitch.set(true);
        } else {
            this.entitlementSwitch.set(false);
            this.activationKey.set(this.activationKeyField.getText());
        }
        return true;
    }

    @Override
    public JComponent getInitialFocus(JComponent jComponent) {
        return this.tableProvider.getFocusableComponent();
    }

    @Override
    public String getAccessibleName() {
        return WizardResourceKeys.ENTITLEMENT_SELECTION_BOLD_LABEL.getString(new Object[0]);
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    @Override
    public void configureNextButton(final AbstractButton abstractButton) {
        abstractButton.setEnabled(this.entitlementButtonSelectedAndDataSelected() || this.activationKeyButtonSelectedAndDataProvided());
        this.tableProvider.getTableSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                abstractButton.setEnabled(EntitlementSelectionPanelUI.this.entitlementButtonSelectedAndDataSelected());
            }
        });
        this.selectLicenseButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                abstractButton.setEnabled(itemEvent.getStateChange() == 1 && EntitlementSelectionPanelUI.this.entitlementSelected());
            }
        });
        this.enterActivationKeyButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                abstractButton.setEnabled(itemEvent.getStateChange() == 1 && EntitlementSelectionPanelUI.this.activationKeyFieldIsNonEmpty());
            }
        });
        this.factory.addDocumentObserver(this.activationKeyField.getDocument(), new WizardObserver(){

            @Override
            public void update() {
                abstractButton.setEnabled(EntitlementSelectionPanelUI.this.activationKeyButtonSelectedAndDataProvided());
            }
        });
    }

    private boolean activationKeyFieldIsNonEmpty() {
        return !this.activationKeyField.getText().isEmpty();
    }

    private boolean activationKeyButtonSelectedAndDataProvided() {
        return this.enterActivationKeyButton.isSelected() && this.activationKeyFieldIsNonEmpty();
    }

    private boolean entitlementButtonSelectedAndDataSelected() {
        return this.selectLicenseButton.isSelected() && this.entitlementSelected();
    }

    private boolean entitlementSelected() {
        return this.selectedEntitlement.get() != null;
    }
}

