/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard.ui.panels;

import com.mathworks.install.udc.UsageDataCollector;
import com.mathworks.install.udc.UsageDataCollectorKey;
import com.mathworks.instutil.AvailablePlatform;
import com.mathworks.instutil.FolderUtils;
import com.mathworks.wizard.WizardObserver;
import com.mathworks.wizard.model.DefaultedModel;
import com.mathworks.wizard.model.PlatformModel;
import com.mathworks.wizard.resources.WizardComponentName;
import com.mathworks.wizard.resources.WizardResourceKeys;
import com.mathworks.wizard.ui.AllButtonProperties;
import com.mathworks.wizard.ui.ComponentName;
import com.mathworks.wizard.ui.components.SwingComponentFactory;
import com.mathworks.wizard.ui.panels.AbstractPanelUI;
import com.mathworks.wizard.ui.panels.PanelBuilder;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;

final class DownloadFolderSelectionPanelUI
extends AbstractPanelUI {
    private final DefaultedModel<File> myFolder;
    private final UsageDataCollector usageDataCollector;
    private final PlatformModel<AvailablePlatform> platformModel;
    private final JPanel panel;
    private final JTextComponent folderTextField;
    private final FolderUtils folderUtils;
    private final Map<AvailablePlatform, AbstractButton> platformCheckBoxes;

    DownloadFolderSelectionPanelUI(ResourceBundle resourceBundle, SwingComponentFactory swingComponentFactory, PanelBuilder panelBuilder, FolderUtils folderUtils, DefaultedModel<File> defaultedModel, PlatformModel<AvailablePlatform> platformModel, UsageDataCollector usageDataCollector) {
        super(resourceBundle, swingComponentFactory, WizardResourceKeys.DOWNLOAD_FOLDER_TITLE.getString(new Object[0]));
        this.platformModel = platformModel;
        this.folderUtils = folderUtils;
        this.myFolder = defaultedModel;
        this.usageDataCollector = usageDataCollector;
        JButton jButton = swingComponentFactory.createButton(AllButtonProperties.RESET, new ResetAction(), WizardComponentName.DOWNLOAD_RESET_BUTTON);
        JComponent jComponent = swingComponentFactory.createLabel(WizardResourceKeys.DOWNLOAD_FOLDER_FIELD_LABEL.getString(new Object[0]), WizardComponentName.DOWNLOAD_FOLDER_FIELD_LABEL);
        this.folderTextField = swingComponentFactory.createTextField(WizardComponentName.DOWNLOAD_TEXT_FIELD, WizardResourceKeys.DOWNLOAD_FOLDER_FIELD_LABEL.getString(new Object[0]));
        String string = ((File)this.myFolder.get()).getAbsolutePath();
        this.folderTextField.setText(string);
        JComponent jComponent2 = swingComponentFactory.createBrowseableFolderTextField(this.folderTextField, WizardComponentName.DOWNLOAD_BROWSE_BUTTON, string);
        swingComponentFactory.addDocumentObserver(this.folderTextField.getDocument(), new SpaceLabelUpdaterWizardObserver());
        JComponent jComponent3 = swingComponentFactory.createLabel(WizardResourceKeys.PLATFORM_SELECTION_LABEL.getString(new Object[0]), WizardComponentName.DOWNLOAD_FOLDER_PLATFORM_SELECTION_LABEL);
        ((PanelBuilder)((PanelBuilder)((PanelBuilder)panelBuilder.addRow(new JComponent[]{jComponent})).addRow(new JComponent[]{jComponent2})).addRightAnchoredRow(new JComponent[]{jButton})).addRow(new JComponent[]{jComponent3});
        this.platformCheckBoxes = new HashMap<AvailablePlatform, AbstractButton>();
        for (final AvailablePlatform availablePlatform : this.platformModel.getOrderedListOfAvailablePlatforms()) {
            AbstractButton abstractButton = swingComponentFactory.createCheckBox(this.platformModel.getDisplayName(availablePlatform), new ComponentName(){

                public String toString() {
                    return WizardComponentName.DOWNLOAD_FOLDER_PLATFORM_CHECKBOX + availablePlatform.getName();
                }
            });
            abstractButton.setSelected(availablePlatform.isSelected());
            this.platformCheckBoxes.put(availablePlatform, abstractButton);
            panelBuilder.addSubRow(new JComponent[]{abstractButton});
        }
        this.panel = ((PanelBuilder)panelBuilder.addVerticalFillRow(new JComponent[0])).buildPanel();
    }

    @Override
    public JComponent getInitialFocus(JComponent jComponent) {
        return this.folderTextField;
    }

    @Override
    public String getAccessibleName() {
        return WizardResourceKeys.DOWNLOAD_FOLDER_TITLE.getString(new Object[0]);
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    @Override
    public void configureNextButton(final AbstractButton abstractButton) {
        abstractButton.setEnabled(this.getPath().length() > 0 && this.platformModel.getSelectedPlatforms().length > 0);
        this.factory.addDocumentObserver(this.folderTextField.getDocument(), new FolderTextFieldObserver(abstractButton));
        for (final AvailablePlatform availablePlatform : this.platformCheckBoxes.keySet()) {
            this.platformCheckBoxes.get(availablePlatform).addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    availablePlatform.setSelected(itemEvent.getStateChange() == 1);
                    DownloadFolderSelectionPanelUI.this.setNextButtonEnabled(abstractButton);
                }
            });
        }
    }

    @Override
    public boolean apply() {
        this.updateFolderModel();
        this.collectUsageData();
        return true;
    }

    private void collectUsageData() {
        String[] stringArray = this.platformModel.getSelectedPlatforms();
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append(string + " ");
        }
        this.usageDataCollector.addData(UsageDataCollectorKey.SESSION_DATA_PLATFORM_DOWNLOADED_FOR, (Object)stringBuilder.toString().trim());
        boolean bl = !((File)this.myFolder.get()).equals(this.myFolder.getDefault());
        this.usageDataCollector.addData(UsageDataCollectorKey.USAGE_DATA_DEFAULT_DOWNLOAD_FOLDER_CHANGED, (Object)bl);
    }

    @Override
    public String getLoggerData() {
        return "Default Download Folder: " + this.folderTextField.getText();
    }

    private void updateFolderModel() {
        this.myFolder.set(new File(this.getPath()));
    }

    private void updateFolderTextField(String string) {
        this.folderTextField.setText(string);
    }

    private String getPath() {
        return this.folderUtils.scrub(this.folderTextField.getText());
    }

    private void setNextButtonEnabled(AbstractButton abstractButton) {
        abstractButton.setEnabled(this.getPath().length() > 0 && this.platformModel.getSelectedPlatforms().length > 0);
    }

    private void updateFolderModelAndSpaceLabels() {
        this.updateFolderModel();
    }

    private class SpaceLabelUpdaterWizardObserver
    implements WizardObserver {
        private SpaceLabelUpdaterWizardObserver() {
        }

        @Override
        public void update() {
            DownloadFolderSelectionPanelUI.this.updateFolderModelAndSpaceLabels();
        }
    }

    private class FolderTextFieldObserver
    implements WizardObserver {
        private AbstractButton nextButton;

        FolderTextFieldObserver(AbstractButton abstractButton) {
            this.nextButton = abstractButton;
        }

        @Override
        public void update() {
            DownloadFolderSelectionPanelUI.this.setNextButtonEnabled(this.nextButton);
        }
    }

    private class ResetAction
    extends AbstractAction {
        private ResetAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DownloadFolderSelectionPanelUI.this.updateFolderTextField(((File)DownloadFolderSelectionPanelUI.this.myFolder.getDefault()).getAbsolutePath());
            DownloadFolderSelectionPanelUI.this.usageDataCollector.addData(UsageDataCollectorKey.USAGE_DATA_RESTORED_DEFAULT_DOWNLOAD_FOLDER, (Object)true);
        }
    }
}

