/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard.ui.components;

import com.mathworks.instutil.FolderUtils;
import com.mathworks.wizard.resources.WizardResourceKeys;
import com.mathworks.wizard.ui.components.FileBrowseStrategy;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;

final class FileBrowseStrategyDefault
implements FileBrowseStrategy {
    private final Frame parent;
    private final FolderUtils folderUtils;

    FileBrowseStrategyDefault(Frame frame, FolderUtils folderUtils) {
        this.parent = frame;
        this.folderUtils = folderUtils;
    }

    @Override
    public Action createFileBrowseAction(final JTextComponent jTextComponent, final String string, final String string2, final FileFilter ... fileFilterArray) {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileBrowseStrategyDefault.this.browse(jTextComponent, string, 0, FileBrowseStrategyDefault.this.getStartFolderLocationForFileChooser(new File(jTextComponent.getText()), string2), fileFilterArray);
            }
        };
    }

    @Override
    public Action createFolderBrowseAction(final JTextComponent jTextComponent, final String string, final String string2, final FileFilter ... fileFilterArray) {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileBrowseStrategyDefault.this.browse(jTextComponent, string, 1, FileBrowseStrategyDefault.this.getStartFolderLocationForFileChooser(new File(jTextComponent.getText()), string2), fileFilterArray);
            }
        };
    }

    private File getStartFolderLocationForFileChooser(File file, String string) {
        File file2 = string != null ? new File(string) : null;
        return this.folderUtils.getSearchPathForFileBrowser(file, file2);
    }

    private void browse(JTextComponent jTextComponent, String string, int n, File file, FileFilter ... fileFilterArray) {
        String string2 = file != null ? file.getAbsolutePath() : null;
        JFileChooser jFileChooser = new JFileChooser(string2);
        jFileChooser.setDialogTitle(string);
        jFileChooser.setFileSelectionMode(n);
        for (FileFilter fileFilter : fileFilterArray) {
            jFileChooser.addChoosableFileFilter(fileFilter);
        }
        String string3 = WizardResourceKeys.FOLDER_BROWSE_BUTTON.getString(new Object[0]);
        int n2 = jFileChooser.showDialog(this.parent, string3);
        if (n2 == 0) {
            File file2 = jFileChooser.getSelectedFile();
            jTextComponent.setText(file2.getAbsolutePath());
        }
    }
}

