/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard.ui.components;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.swing.EventSelectionModel;
import ca.odell.glazedlists.swing.EventTableModel;
import com.mathworks.instutil.wizard.SizedColumnLicenseTable;
import com.mathworks.wizard.model.AccessibleTableFormat;
import java.awt.Component;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

abstract class AbstractTable<T>
extends SizedColumnLicenseTable {
    protected final EventList<T> eventList = new BasicEventList();
    protected final EventTableModel<T> tableModel;

    AbstractTable(EventList<T> eventList, AccessibleTableFormat<T> accessibleTableFormat, String string, String string2) {
        this.eventList.addAll(eventList);
        this.tableModel = new EventTableModel(this.eventList, accessibleTableFormat);
        this.setModel((TableModel)this.tableModel);
        EventSelectionModel eventSelectionModel = new EventSelectionModel(this.eventList);
        eventSelectionModel.setSelectionMode(0);
        this.setSelectionModel((ListSelectionModel)eventSelectionModel);
        AccessibleTableSelectionListener accessibleTableSelectionListener = new AccessibleTableSelectionListener((JTable)((Object)this), accessibleTableFormat);
        this.selectionModel.addListSelectionListener(accessibleTableSelectionListener);
        this.selectionModel.setLeadSelectionIndex(0);
        this.setRowSelectionAllowed(true);
        this.setRowHeight(this.getFontMetrics(this.getFont()).getHeight() + 2);
        this.sizeTableColumnsToContents();
        this.setName(string);
        this.getAccessibleContext().setAccessibleName(string2);
    }

    protected void leftAlignColumnAt(int n) {
        TableColumn tableColumn = this.columnModel.getColumn(n);
        LeftAlignRenderer leftAlignRenderer = new LeftAlignRenderer();
        tableColumn.setHeaderRenderer(leftAlignRenderer);
    }

    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Component component = super.prepareRenderer(tableCellRenderer, n, n2);
        component.setEnabled(this.isEnabled());
        ((JComponent)component).setBorder(new EmptyBorder(5, 5, 5, 5));
        return component;
    }

    private final class AccessibleTableSelectionListener
    implements ListSelectionListener {
        private JTable table;
        private AccessibleTableFormat<T> tableFormat;

        AccessibleTableSelectionListener(JTable jTable, AccessibleTableFormat<T> accessibleTableFormat) {
            this.table = jTable;
            this.tableFormat = accessibleTableFormat;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            if (this.table.getRowCount() > 0 && !listSelectionModel.isSelectionEmpty()) {
                this.setAccessibleNameForSelectedCell(this.table);
            }
        }

        private void setAccessibleNameForSelectedCell(JTable jTable) {
            ListSelectionModel listSelectionModel = jTable.getSelectionModel();
            int n = listSelectionModel.getLeadSelectionIndex();
            int n2 = jTable.getSelectedColumn();
            if (n > -1 && n2 > -1) {
                Object object = jTable.getValueAt(n, n2);
                TableCellRenderer tableCellRenderer = jTable.getCellRenderer(n, n2);
                Component component = tableCellRenderer.getTableCellRendererComponent(jTable, object, true, true, n, n2);
                AccessibleContext accessibleContext = component.getAccessibleContext();
                Object object2 = AbstractTable.this.tableModel.getElementAt(n);
                accessibleContext.setAccessibleName(this.tableFormat.getAccessibleName(object2, n2));
            }
        }
    }

    private static class LeftAlignRenderer
    extends DefaultTableCellRenderer {
        private LeftAlignRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JTableHeader jTableHeader = jTable.getTableHeader();
            TableCellRenderer tableCellRenderer = jTableHeader.getDefaultRenderer();
            Component component = tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            ((JLabel)component).setHorizontalAlignment(2);
            return component;
        }
    }
}

