/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard.ui;

import com.mathworks.wizard.ui.OptionPaneButtonProperties;
import com.mathworks.wizard.ui.Response;
import com.mathworks.wizard.ui.components.ButtonFactory;
import com.mathworks.wizard.ui.components.SwingComponentFactory;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JOptionPane;

public enum OptionType {
    YES_NO(OptionPaneButtonProperties.YES, OptionPaneButtonProperties.NO),
    OK_CANCEL(OptionPaneButtonProperties.OK, OptionPaneButtonProperties.CANCEL),
    DEFAULT(OptionPaneButtonProperties.OK),
    YESTOALL_NOTOALL(OptionPaneButtonProperties.YES, OptionPaneButtonProperties.YESTOALL, OptionPaneButtonProperties.NO, OptionPaneButtonProperties.NOTOALL, OptionPaneButtonProperties.CANCEL),
    YES_NO_CANCEL(OptionPaneButtonProperties.YES, OptionPaneButtonProperties.NO, OptionPaneButtonProperties.CANCEL),
    DEFAULT_NO_YES_NO_CANCEL(1, OptionPaneButtonProperties.YES, OptionPaneButtonProperties.NO, OptionPaneButtonProperties.CANCEL),
    DEFAULT_NO_YES_NO(1, OptionPaneButtonProperties.YES, OptionPaneButtonProperties.NO);

    private final OptionPaneButtonProperties[] buttonProperties;
    private final int idx;

    private OptionType(OptionPaneButtonProperties ... optionPaneButtonPropertiesArray) {
        this(0, optionPaneButtonPropertiesArray);
    }

    private OptionType(int n2, OptionPaneButtonProperties ... optionPaneButtonPropertiesArray) {
        this.idx = Math.min(Math.max(0, n2), optionPaneButtonPropertiesArray.length - 1);
        this.buttonProperties = (OptionPaneButtonProperties[])optionPaneButtonPropertiesArray.clone();
    }

    public void configure(SwingComponentFactory swingComponentFactory, JOptionPane jOptionPane) {
        Object[] objectArray = this.getOptions(swingComponentFactory, jOptionPane);
        jOptionPane.setOptions(objectArray);
        jOptionPane.setInitialValue(objectArray[this.idx]);
    }

    public Response getDefaultResponse() {
        return this.buttonProperties[this.idx].getResponse();
    }

    private Component[] getOptions(SwingComponentFactory swingComponentFactory, JOptionPane jOptionPane) {
        ButtonFactory buttonFactory = swingComponentFactory.createButtonFactory(this.buttonProperties);
        ArrayList<JButton> arrayList = new ArrayList<JButton>();
        for (OptionPaneButtonProperties optionPaneButtonProperties : this.buttonProperties) {
            arrayList.add(buttonFactory.createButton(optionPaneButtonProperties, new OptionPaneAction(jOptionPane, optionPaneButtonProperties.getResponse()), optionPaneButtonProperties.getName()));
        }
        return arrayList.toArray(new Component[arrayList.size()]);
    }

    private static final class OptionPaneAction
    extends AbstractAction {
        private final JOptionPane fPane;
        private final Response fValue;

        OptionPaneAction(JOptionPane jOptionPane, Response response) {
            this.fPane = jOptionPane;
            this.fValue = response;
        }

        @Override
        public final void actionPerformed(ActionEvent actionEvent) {
            this.fPane.setValue((Object)this.fValue);
        }
    }
}

