/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard.model;

import com.mathworks.instutil.Arch;
import com.mathworks.instutil.AvailablePlatform;
import com.mathworks.instutil.AvailablePlatformImpl;
import com.mathworks.instutil.InstutilResourceKeys;
import com.mathworks.wizard.model.PlatformModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class PlatformModelImpl
implements PlatformModel<AvailablePlatform> {
    private static Map<String, String> archToDisplayNameMap = new HashMap<String, String>();
    private final AvailablePlatform[] ALL_PLATFORMS = new AvailablePlatform[]{new AvailablePlatformImpl(Arch.WIN64), new AvailablePlatformImpl(Arch.MACI64), new AvailablePlatformImpl(Arch.GLNXA64)};

    @Override
    public Collection<AvailablePlatform> getOrderedListOfAvailablePlatforms() {
        return Arrays.asList(this.ALL_PLATFORMS);
    }

    @Override
    public String[] getSelectedPlatforms() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (AvailablePlatform availablePlatform : this.ALL_PLATFORMS) {
            if (!availablePlatform.isSelected()) continue;
            arrayList.add(availablePlatform.getName());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    public String getDisplayName(AvailablePlatform availablePlatform) {
        return archToDisplayNameMap.get(availablePlatform.getName());
    }

    @Override
    public String[] getDisplayNamesForSelectedPlatforms() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (AvailablePlatform availablePlatform : this.ALL_PLATFORMS) {
            if (!availablePlatform.isSelected()) continue;
            arrayList.add(this.getDisplayName(availablePlatform));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    static {
        archToDisplayNameMap.put(Arch.WIN64.getString(), InstutilResourceKeys.PLATFORM_DISPLAY_NAME_WIN64.getString(new Object[0]));
        archToDisplayNameMap.put(Arch.MACI64.getString(), InstutilResourceKeys.PLATFORM_DISPLAY_NAME_MACI64.getString(new Object[0]));
        archToDisplayNameMap.put(Arch.GLNXA64.getString(), InstutilResourceKeys.PLATFORM_DISPLAY_NAME_GLNXA64.getString(new Object[0]));
    }
}

