/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.mathworks.instutil.DefaultSecurityOverrideImpl;
import com.mathworks.instutil.DisplayProperties;
import com.mathworks.instutil.DisplayPropertiesImpl;
import com.mathworks.instutil.ExecutorServiceManager;
import com.mathworks.instutil.ExecutorServiceManagerImpl;
import com.mathworks.instutil.InstUtilPropertyKey;
import com.mathworks.instutil.JNIException;
import com.mathworks.instutil.MacSecurityOverrideImpl;
import com.mathworks.instutil.Platform;
import com.mathworks.instutil.PlatformImpl;
import com.mathworks.instutil.ProcessExecutor;
import com.mathworks.instutil.ProcessExecutorImpl;
import com.mathworks.instutil.ResourceLocale;
import com.mathworks.instutil.ResourceLocaleFactory;
import com.mathworks.instutil.SecurityOverride;
import com.mathworks.wizard.BlockingExitHandler;
import com.mathworks.wizard.ExceptionHandler;
import com.mathworks.wizard.ExceptionHandlerImpl;
import com.mathworks.wizard.ExitHandler;
import com.mathworks.wizard.ExitStrategy;
import com.mathworks.wizard.ExitStrategyDefault;
import com.mathworks.wizard.PropertyKey;
import com.mathworks.wizard.ResourceRetriever;
import com.mathworks.wizard.ResourceRetrieverImpl;
import com.mathworks.wizard.SourcePathProvider;
import com.mathworks.wizard.StandaloneExitStrategySystemExit;
import com.mathworks.wizard.WebServicesModule;
import com.mathworks.wizard.WizardFactory;
import com.mathworks.wizard.WizardFactoryImpl;
import com.mathworks.wizard.worker.WorkerFactory;
import com.mathworks.wizard.worker.WorkerFactoryImpl;
import java.util.Properties;
import java.util.ResourceBundle;

final class WizardModule
extends AbstractModule {
    WizardModule() {
    }

    protected void configure() {
        this.bind(ExceptionHandler.class).to(ExceptionHandlerImpl.class).in(Scopes.SINGLETON);
        this.bind(ExecutorServiceManager.class).to(ExecutorServiceManagerImpl.class).in(Scopes.SINGLETON);
        this.bind(Platform.class).to(PlatformImpl.class);
        this.bind(ProcessExecutor.class).to(ProcessExecutorImpl.class);
        this.bind(ExitHandler.class).to(BlockingExitHandler.class).in(Scopes.SINGLETON);
        this.bind(WizardFactory.class).to(WizardFactoryImpl.class);
        this.bind(WorkerFactory.class).to(WorkerFactoryImpl.class);
        this.install((Module)new WebServicesModule());
    }

    @Provides
    static ResourceRetriever provideResourceRetriever() {
        return new ResourceRetrieverImpl(new String[0]);
    }

    @Provides
    static SourcePathProvider provideSourcePathProvider(final Properties properties) {
        return new SourcePathProvider(){

            @Override
            public String getSourcePath() {
                return properties.getProperty(PropertyKey.ROOTDIR.get());
            }
        };
    }

    @Provides
    static DisplayProperties provideDisplayProperties(SourcePathProvider sourcePathProvider, Platform platform, Properties properties) throws JNIException {
        String string = WizardModule.getRootLibDir(properties, sourcePathProvider);
        return new DisplayPropertiesImpl(platform.getNativeLibraryPath(string));
    }

    @Provides
    static SecurityOverride provideSecurityOverride(SourcePathProvider sourcePathProvider, Platform platform, Properties properties) throws JNIException {
        DefaultSecurityOverrideImpl defaultSecurityOverrideImpl;
        if (platform.isMac()) {
            String string = properties.getProperty(PropertyKey.MODE.get(), "interactive");
            if (string.equalsIgnoreCase("silent")) {
                defaultSecurityOverrideImpl = new DefaultSecurityOverrideImpl();
            } else {
                String string2 = WizardModule.getRootLibDir(properties, sourcePathProvider);
                defaultSecurityOverrideImpl = new MacSecurityOverrideImpl(platform.getNativeLibraryPath(string2));
            }
        } else {
            defaultSecurityOverrideImpl = new DefaultSecurityOverrideImpl();
        }
        return defaultSecurityOverrideImpl;
    }

    @Provides
    static ResourceBundle provideResourceBundle(Platform platform) {
        ResourceLocale resourceLocale = ResourceLocaleFactory.createResourceLocale((Platform)platform);
        return resourceLocale.getBundle("com.mathworks.wizard.resources.RES_Wizard");
    }

    @Provides
    static ExitStrategy provideExitStrategy(Properties properties, Platform platform) {
        if ((platform.isMac() || platform.isLinux()) && Boolean.valueOf(properties.getProperty(PropertyKey.STANDALONE.get(), "false")).booleanValue()) {
            return new StandaloneExitStrategySystemExit();
        }
        return new ExitStrategyDefault();
    }

    private static String getRootLibDir(Properties properties, SourcePathProvider sourcePathProvider) {
        String string = properties.getProperty(InstUtilPropertyKey.LIBDIR.get());
        if (string == null) {
            string = sourcePathProvider.getSourcePath();
        }
        return string;
    }
}

