/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard;

import com.mathworks.wizard.ExitHandler;
import com.mathworks.wizard.ExitStatus;
import com.mathworks.wizard.Step;
import com.mathworks.wizard.StepCallback;
import com.mathworks.wizard.StepSequencer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

final class StepSequencerImpl
implements StepSequencer {
    private final ExitHandler exitHandler;

    StepSequencerImpl(ExitHandler exitHandler) {
        this.exitHandler = exitHandler;
    }

    @Override
    public void startSequence(Step ... stepArray) {
        if (stepArray.length == 0) {
            throw new IllegalArgumentException("1 or more steps must be provided.");
        }
        StepSequenceController stepSequenceController = new StepSequenceController(stepArray);
        stepSequenceController.stepForward();
    }

    private class StepSequenceController
    implements StepCallback {
        private final List<Step> stepSequence = new ArrayList<Step>();
        private int currentStepIdx = -1;

        StepSequenceController(Step ... stepArray) {
            this.stepSequence.addAll(Arrays.asList(stepArray));
        }

        @Override
        public void stepBack() {
            if (this.canStepBack()) {
                Step step = this.stepSequence.get(--this.currentStepIdx);
                step.reverseVisitStep(this);
            } else {
                StepSequencerImpl.this.exitHandler.exit(ExitStatus.FAILED);
            }
        }

        @Override
        public void stepForward() {
            if (this.canStepForward()) {
                Step step = this.stepSequence.get(++this.currentStepIdx);
                step.forwardVisitStep(this);
            } else {
                StepSequencerImpl.this.exitHandler.exit(ExitStatus.SUCCESS);
            }
        }

        @Override
        public boolean canStepBack() {
            return this.currentStepIdx > 0;
        }

        @Override
        public boolean canStepForward() {
            return this.currentStepIdx < this.stepSequence.size() - 1;
        }
    }
}

