/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard;

import com.google.inject.Inject;
import com.mathworks.instutil.logging.AppLogger;
import com.mathworks.instutil.logging.ArgumentLoggingFilterImpl;
import com.mathworks.instutil.logging.LoggingFilter;
import com.mathworks.instutil.logging.LoggingFilterStrategy;
import com.mathworks.instutil.properties.ApplicationInputFileReader;
import com.mathworks.wizard.ArgumentsParser;
import com.mathworks.wizard.NormalizedProperties;
import com.mathworks.wizard.PropertyKey;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Queue;

public final class ArgumentsParserImpl
implements ArgumentsParser {
    private final ApplicationInputFileReader propFileReader;
    private static final String DEFAULT_SWITCH_VALUE = String.valueOf(true);
    private AppLogger appLogger;
    private final LoggingFilter loggingFilter;

    @Inject
    public ArgumentsParserImpl(ApplicationInputFileReader applicationInputFileReader, AppLogger appLogger, LoggingFilterStrategy loggingFilterStrategy) {
        this.propFileReader = applicationInputFileReader;
        this.appLogger = appLogger;
        this.loggingFilter = new ArgumentLoggingFilterImpl(loggingFilterStrategy);
    }

    @Override
    public Properties parse(String ... stringArray) {
        NormalizedProperties normalizedProperties = new NormalizedProperties();
        LinkedList<String> linkedList = new LinkedList<String>(Arrays.asList(stringArray));
        this.appLogger.logMsg("Input arguments: ");
        while (!linkedList.isEmpty()) {
            String string = ArgumentsParserImpl.findFirstCommand(linkedList);
            if (!ArgumentsParserImpl.isCommand(string)) continue;
            String string2 = ArgumentsParserImpl.getKey(string);
            String string3 = ArgumentsParserImpl.getValue(linkedList);
            ((Properties)normalizedProperties).setProperty(string2, string3);
            if (this.loggingFilter.shouldLog(string2)) {
                this.appLogger.logMsg(string2 + " " + string3);
            } else {
                this.appLogger.logMsg("Argument not logged");
            }
            if (!PropertyKey.INPUT_FILE.matches(string2)) continue;
            try {
                this.propFileReader.loadInputFile(string3, (Properties)normalizedProperties);
            }
            catch (IOException iOException) {
                this.appLogger.logMsg("Error loading input file " + string3);
                this.appLogger.logMsg(iOException.getMessage());
            }
        }
        return normalizedProperties;
    }

    private static String getValue(Queue<String> queue) {
        if (!queue.isEmpty()) {
            return ArgumentsParserImpl.getValueFromQueue(queue);
        }
        return DEFAULT_SWITCH_VALUE;
    }

    private static String getValueFromQueue(Queue<String> queue) {
        String string = queue.peek();
        if (ArgumentsParserImpl.isCommand(string)) {
            return DEFAULT_SWITCH_VALUE;
        }
        return queue.poll();
    }

    private static String getKey(String string) {
        return string.substring(1);
    }

    private static boolean isCommand(String string) {
        return string.startsWith("-");
    }

    private static String findFirstCommand(Queue<String> queue) {
        String string = "";
        while (!ArgumentsParserImpl.isCommand(string) && !queue.isEmpty()) {
            string = queue.poll();
        }
        return string;
    }
}

