/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwebservices.cws.v2;

import com.mathworks.mlwebservices.DefaultService;
import com.mathworks.mlwebservices.WSEndPoints;
import com.mathworks.mlwebservices.WSSwingWorker;
import com.mathworks.mlwebservices.cws.v2.gen.ContentRequest;
import com.mathworks.mlwebservices.cws.v2.gen.ContentServiceStub;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class ContentWebServiceV2
extends DefaultService {
    private static final int TIME_OUT = 20000;
    private ContentServiceStub serviceConnection = null;
    private boolean bindingFinished = false;

    @Override
    public boolean isConnected() {
        return this.serviceConnection != null;
    }

    public boolean isFinished() {
        return this.bindingFinished;
    }

    @Override
    public WSSwingWorker getBindingThread(String string) {
        return new BindingThread();
    }

    @Override
    public void disconnect() {
        this.serviceConnection = null;
    }

    public static ContentWebServiceV2 bindToWebServiceNow(String string) {
        return new ContentWebServiceV2(true, string);
    }

    public static ContentWebServiceV2 bindToWebServiceInBackground(String string) {
        return new ContentWebServiceV2(false, string);
    }

    public String getContent(String string, String string2) {
        String string3 = null;
        if (this.isConnected()) {
            try {
                ContentRequest contentRequest = new ContentRequest();
                contentRequest.setClientString(string2);
                contentRequest.setGuid(string);
                contentRequest.setLocale(Locale.getDefault().toString());
                string3 = this.serviceConnection.getContent(contentRequest).getContent();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return string3;
    }

    private ContentWebServiceV2(boolean bl, String string) {
        this.setEndpointURL(string);
        BindingThread bindingThread = new BindingThread();
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Future<?> future = executorService.submit(bindingThread);
        if (bl) {
            try {
                future.get(20000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException exception) {
                exception.printStackTrace();
            }
            catch (TimeoutException timeoutException) {
                this.serviceConnection = null;
            }
        }
        executorService.shutdown();
    }

    @Override
    public String getDefaultEndpointURL() {
        return WSEndPoints.getContentWSEndPoint();
    }

    private final class BindingThread
    extends WSSwingWorker {
        private BindingThread() {
        }

        @Override
        public void run() {
            ContentServiceStub contentServiceStub;
            try {
                String string = ContentWebServiceV2.this.getEndpointURL();
                contentServiceStub = new ContentServiceStub(string);
                ContentWebServiceV2.this.configureOptions(contentServiceStub);
            }
            catch (Throwable throwable) {
                contentServiceStub = null;
            }
            if (!this.isCancelled()) {
                ContentWebServiceV2.this.serviceConnection = contentServiceStub;
            }
            ContentWebServiceV2.this.bindingFinished = true;
        }
    }
}

