/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instwiz.proxy;

import com.mathworks.instutil.InstUtilResourceBundle;
import com.mathworks.instutil.services.ServiceThread;
import com.mathworks.instutil.services.ServiceThreadState;
import com.mathworks.instutil.services.ServiceThreadView;
import com.mathworks.instwiz.ButtonFactory;
import com.mathworks.instwiz.InstWizardIntf;
import com.mathworks.instwiz.WIButtonProperties;
import com.mathworks.instwiz.WILayoutFocusTraversalPolicy;
import com.mathworks.instwiz.WIPaintedPanel;
import com.mathworks.instwiz.WIPanel;
import com.mathworks.instwiz.proxy.AbstractProxyDialog;
import com.mathworks.instwiz.proxy.AbstractProxyPanel;
import com.mathworks.instwiz.proxy.DefaultProxyPanel;
import com.mathworks.instwiz.resources.WIComponentName;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;

public class DefaultProxyDialog
extends AbstractProxyDialog {
    private final JButton fOkButton;
    private final JButton fCancelButton;
    private final InstWizardIntf fApp;
    private final AbstractProxyPanel fProxyPanel;
    private static final String EMPTY_STRING = "";

    protected DefaultProxyDialog(InstWizardIntf instWizardIntf) {
        super(instWizardIntf.getFrame());
        this.fApp = instWizardIntf;
        ButtonFactory buttonFactory = this.fApp.getButtonFactory();
        this.fOkButton = buttonFactory.createButton(WIButtonProperties.OK, new OkAction(), WIComponentName.DEFAULT_PROXY_OK);
        this.fCancelButton = buttonFactory.createButton(WIButtonProperties.CANCEL, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefaultProxyDialog.this.dispose();
            }
        }, WIComponentName.DEFAULT_PROXY_CANCEL);
        this.fProxyPanel = new DefaultProxyPanel(instWizardIntf);
        JPanel jPanel = this.getMainPanel();
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setBorder(null);
        this.add(jScrollPane);
        WILayoutFocusTraversalPolicy wILayoutFocusTraversalPolicy = new WILayoutFocusTraversalPolicy();
        this.setFocusTraversalPolicy(wILayoutFocusTraversalPolicy);
        this.pack();
        this.setLocationRelativeTo(this.fApp.getFrame());
        this.setModal(true);
    }

    protected JPanel getMainPanel() {
        JPanel jPanel = this.getButtonPanel();
        Border border = BorderFactory.createEmptyBorder(10, 0, 0, 0);
        this.fProxyPanel.setBorder(border);
        WIPaintedPanel wIPaintedPanel = new WIPaintedPanel(this.fApp);
        wIPaintedPanel.setLayout(new BorderLayout());
        wIPaintedPanel.add((Component)this.fProxyPanel, "Center");
        wIPaintedPanel.add((Component)jPanel, "South");
        this.fProxyPanel.setOpaque(false);
        jPanel.setOpaque(false);
        return wIPaintedPanel;
    }

    protected JPanel getButtonPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = WIPanel.getSpace(this.fApp);
        gridBagConstraints.insets = new Insets(0, n, n, n);
        jPanel.add((Component)this.fOkButton, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, n, n);
        jPanel.add((Component)this.fCancelButton, gridBagConstraints);
        return jPanel;
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            String string = this.getProxyHost();
            this.getServerTextField().setText(string);
            String string2 = this.getProxyPort();
            this.getPortTextField().setText(string2);
            String string3 = this.getProxyUser();
            this.getUserTextField().setText(string3);
            String string4 = this.getProxyPassword();
            this.getPasswordTextField().setText(string4);
            InstWizardIntf instWizardIntf = this.fApp;
            InstUtilResourceBundle instUtilResourceBundle = instWizardIntf.getResources();
            JComponent jComponent = this.getInitialFocus();
            String string5 = instUtilResourceBundle.getString("proxy.title");
            if (this.fOkButton != null) {
                JRootPane jRootPane = instWizardIntf.getRootPane();
                jRootPane.setDefaultButton(this.fOkButton);
            }
            if (jComponent != null) {
                jComponent.requestFocusInWindow();
            }
            this.setTitle(string5);
            if (!instWizardIntf.isInteractive()) {
                int n = instWizardIntf.getTimeout();
                Timer timer = new Timer(n, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (DefaultProxyDialog.this.fOkButton != null) {
                            DefaultProxyDialog.this.fOkButton.doClick();
                        }
                    }
                });
                timer.setRepeats(false);
                timer.start();
            }
            if (instWizardIntf.isCommandLine()) {
                this.doCommandLine();
            }
            this.rootPane.setDefaultButton(this.fOkButton);
        }
        super.setVisible(bl);
    }

    @Override
    public void doCommandLine() {
        InstUtilResourceBundle instUtilResourceBundle = this.fApp.getResources();
        String string = instUtilResourceBundle.getString("cl.host") + ' ';
        String string2 = instUtilResourceBundle.getString("cl.port") + ' ';
        String string3 = instUtilResourceBundle.getString("cl.user") + ' ';
        String string4 = instUtilResourceBundle.getString("cl.pword") + ' ';
        System.out.print(string);
        String string5 = this.getInput();
        JTextComponent jTextComponent = this.getServerTextField();
        jTextComponent.setText(string5);
        System.out.print(string2);
        String string6 = this.getInput();
        JTextComponent jTextComponent2 = this.getPortTextField();
        jTextComponent2.setText(string6);
        System.out.print(string3);
        String string7 = this.getInput();
        JTextComponent jTextComponent3 = this.getUserTextField();
        jTextComponent3.setText(string7);
        System.out.print(string4);
        String string8 = this.getInput();
        JTextComponent jTextComponent4 = this.getPasswordTextField();
        jTextComponent4.setText(string8);
        this.fOkButton.doClick();
    }

    private String getInput() {
        byte[] byArray = new byte[256];
        int n = 0;
        try {
            n = System.in.read(byArray);
        }
        catch (IOException iOException) {
            this.fApp.exception(iOException, false);
        }
        String string = new String(byArray, 0, n);
        return string.trim();
    }

    private JComponent getInitialFocus() {
        JTextComponent jTextComponent = this.getServerTextField();
        String string = jTextComponent.getText();
        JComponent jComponent = this.fOkButton;
        if (EMPTY_STRING.equals(string)) {
            jComponent = jTextComponent;
        } else {
            JTextComponent jTextComponent2 = this.getPortTextField();
            String string2 = jTextComponent2.getText();
            if (EMPTY_STRING.equals(string2)) {
                jComponent = jTextComponent2;
            } else {
                JTextComponent jTextComponent3 = this.getUserTextField();
                String string3 = jTextComponent3.getText();
                if (EMPTY_STRING.equals(string3)) {
                    jComponent = jTextComponent3;
                } else {
                    JTextComponent jTextComponent4 = this.getPasswordTextField();
                    String string4 = jTextComponent4.getText();
                    if (EMPTY_STRING.equals(string4)) {
                        jComponent = jTextComponent4;
                    }
                }
            }
        }
        return jComponent;
    }

    protected void doOkButtonAction() {
        JTextComponent jTextComponent = this.getServerTextField();
        final String string = jTextComponent.getText().trim();
        JTextComponent jTextComponent2 = this.getPortTextField();
        final String string2 = jTextComponent2.getText().trim();
        JTextComponent jTextComponent3 = this.getUserTextField();
        final String string3 = jTextComponent3.getText().trim();
        JTextComponent jTextComponent4 = this.getPasswordTextField();
        final String string4 = jTextComponent4.getText().trim();
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                if (!(DefaultProxyDialog.EMPTY_STRING.equalsIgnoreCase(string) && DefaultProxyDialog.EMPTY_STRING.equalsIgnoreCase(string2) && DefaultProxyDialog.EMPTY_STRING.equalsIgnoreCase(string3) && DefaultProxyDialog.EMPTY_STRING.equalsIgnoreCase(string4))) {
                    String string5;
                    String string22;
                    String string32;
                    boolean bl = false;
                    if (!DefaultProxyDialog.EMPTY_STRING.equalsIgnoreCase(string) && !DefaultProxyDialog.EMPTY_STRING.equalsIgnoreCase(string2)) {
                        string32 = DefaultProxyDialog.this.getProxyHost();
                        string22 = DefaultProxyDialog.this.getProxyPort();
                        string5 = DefaultProxyDialog.this.getProxyUser();
                        String string42 = DefaultProxyDialog.this.getProxyPassword();
                        DefaultProxyDialog.this.setProxyHost(string);
                        DefaultProxyDialog.this.setProxyPort(string2);
                        DefaultProxyDialog.this.setProxyUser(string3);
                        DefaultProxyDialog.this.setProxyPassword(string4);
                        ServiceThread serviceThread = DefaultProxyDialog.this.fApp.getServiceThreadFactory().createProxyTestThread((ServiceThreadView)DefaultProxyDialog.this.fApp);
                        serviceThread.startAndWait();
                        ServiceThreadState serviceThreadState = serviceThread.getStatus();
                        if (serviceThreadState == ServiceThreadState.SUCCESS) {
                            DefaultProxyDialog.this.disposeNowOnEDT();
                        } else {
                            if (string32 == null) {
                                DefaultProxyDialog.this.setProxyHost(DefaultProxyDialog.EMPTY_STRING);
                            } else {
                                DefaultProxyDialog.this.setProxyHost(string32);
                            }
                            if (string22 == null) {
                                DefaultProxyDialog.this.setProxyPort(DefaultProxyDialog.EMPTY_STRING);
                            } else {
                                DefaultProxyDialog.this.setProxyPort(string22);
                            }
                            if (string5 == null) {
                                DefaultProxyDialog.this.setProxyUser(DefaultProxyDialog.EMPTY_STRING);
                            } else {
                                DefaultProxyDialog.this.setProxyUser(string5);
                            }
                            if (string42 == null) {
                                DefaultProxyDialog.this.setProxyPassword(DefaultProxyDialog.EMPTY_STRING);
                            } else {
                                DefaultProxyDialog.this.setProxyPassword(string42);
                            }
                            if (serviceThreadState == ServiceThreadState.FAIL && DefaultProxyDialog.this.fApp.isInteractive()) {
                                bl = true;
                            }
                        }
                    } else {
                        bl = true;
                    }
                    if (bl) {
                        string32 = DefaultProxyDialog.this.fApp.getResources();
                        string22 = string32.getString("proxy.error.text");
                        string5 = string32.getString("proxy.error.title");
                        DefaultProxyDialog.this.fApp.showPanel(string22, string5, 0, -1);
                    }
                } else {
                    if (DefaultProxyDialog.this.getProxyHost() != null && !DefaultProxyDialog.this.getProxyHost().equals(DefaultProxyDialog.EMPTY_STRING)) {
                        DefaultProxyDialog.this.setProxyHost(DefaultProxyDialog.EMPTY_STRING);
                    }
                    if (DefaultProxyDialog.this.getProxyPort() != null && !DefaultProxyDialog.this.getProxyPort().equals(DefaultProxyDialog.EMPTY_STRING)) {
                        DefaultProxyDialog.this.setProxyPort(DefaultProxyDialog.EMPTY_STRING);
                    }
                    if (DefaultProxyDialog.this.getProxyUser() != null && !DefaultProxyDialog.this.getProxyUser().equals(DefaultProxyDialog.EMPTY_STRING)) {
                        DefaultProxyDialog.this.setProxyUser(DefaultProxyDialog.EMPTY_STRING);
                    }
                    if (DefaultProxyDialog.this.getProxyPassword() != null && !DefaultProxyDialog.this.getProxyPassword().equals(DefaultProxyDialog.EMPTY_STRING)) {
                        DefaultProxyDialog.this.setProxyPassword(DefaultProxyDialog.EMPTY_STRING);
                    }
                    DefaultProxyDialog.this.disposeNowOnEDT();
                }
                return null;
            }
        }.execute();
    }

    private void disposeNowOnEDT() {
        this.fApp.doNowOnEDT(new Runnable(){

            @Override
            public void run() {
                DefaultProxyDialog.this.dispose();
            }
        });
    }

    @Override
    public JButton getOkButton() {
        return this.fOkButton;
    }

    @Override
    public JButton getCancelButton() {
        return this.fCancelButton;
    }

    protected AbstractProxyPanel getProxyPanel() {
        return this.fProxyPanel;
    }

    protected JTextComponent getServerTextField() {
        return this.fProxyPanel.getServerTextField();
    }

    protected JTextComponent getPortTextField() {
        return this.fProxyPanel.getPortTextField();
    }

    protected JTextComponent getUserTextField() {
        return this.fProxyPanel.getUserTextField();
    }

    protected JTextComponent getPasswordTextField() {
        return this.fProxyPanel.getPasswordTextField();
    }

    protected String getProxyHost() {
        return this.fApp.getTransportClientProperties().getProxyHost();
    }

    protected void setProxyHost(String string) {
        this.fApp.getTransportClientProperties().setProxyHost(string);
    }

    protected String getProxyPort() {
        return this.fApp.getTransportClientProperties().getProxyPort();
    }

    protected void setProxyPort(String string) {
        this.fApp.getTransportClientProperties().setProxyPort(string);
    }

    protected String getProxyUser() {
        return this.fApp.getTransportClientProperties().getProxyUser();
    }

    protected void setProxyUser(String string) {
        this.fApp.getTransportClientProperties().setProxyUser(string);
    }

    protected String getProxyPassword() {
        return this.fApp.getTransportClientProperties().getProxyPassword();
    }

    protected void setProxyPassword(String string) {
        this.fApp.getTransportClientProperties().setProxyPassword(string);
    }

    @Override
    public InstWizardIntf getWizard() {
        return this.fApp;
    }

    private class OkAction
    extends AbstractAction {
        private OkAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DefaultProxyDialog.this.doOkButtonAction();
        }
    }
}

