/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instwiz.arch;

import com.mathworks.instutil.Machine;
import com.mathworks.instutil.ProcessExecutorImpl;
import com.mathworks.instutil.wizard.SelectAllOnFocusListener;
import com.mathworks.instwiz.InstWizardIntf;
import com.mathworks.instwiz.WILicenseFileChooser;
import com.mathworks.instwiz.arch.ArchGui;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.TimeoutException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;

public abstract class ArchGuiBase
implements ArchGui {
    @Override
    public Map<String, Object> getArchSpecificUIProperties() {
        return Collections.emptyMap();
    }

    @Override
    public boolean isHighContrast(InstWizardIntf instWizardIntf, Machine machine) {
        return false;
    }

    @Override
    public void waitForInstallProcess(Process process) throws IOException, TimeoutException, InterruptedException {
        new ProcessExecutorImpl().executeWithTimeout(process);
    }

    @Override
    public void configureButton(AbstractButton abstractButton, int n) {
        if (abstractButton.getBorder() instanceof EmptyBorder) {
            abstractButton.setOpaque(false);
        }
        abstractButton.setMnemonic(n);
    }

    @Override
    public ResourceBundle getBundle(String string) {
        return ResourceBundle.getBundle(string);
    }

    @Override
    public Action createLicenseFileBrowseAction(InstWizardIntf instWizardIntf, JTextComponent jTextComponent) {
        return new LicenseFileBrowseAction(instWizardIntf, jTextComponent);
    }

    @Override
    public SelectAllOnFocusListener.SelectAllBehavior getSelectAllBehavior() {
        return SelectAllOnFocusListener.SelectAllBehavior.KEYBOARD;
    }

    private static final class LicenseFileBrowseAction
    extends AbstractAction {
        private InstWizardIntf fWizard;
        private JTextComponent fLicenseTextField;

        LicenseFileBrowseAction(InstWizardIntf instWizardIntf, JTextComponent jTextComponent) {
            this.fWizard = instWizardIntf;
            this.fLicenseTextField = jTextComponent;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            WILicenseFileChooser wILicenseFileChooser = new WILicenseFileChooser(this.fWizard, this.fLicenseTextField.getText());
            int n = wILicenseFileChooser.showDialog(this.fWizard.getFrame(), null);
            if (n == 0) {
                File file = wILicenseFileChooser.getSelectedFile();
                this.fLicenseTextField.setText(file.getAbsolutePath());
            }
        }
    }
}

