/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instwiz;

import com.mathworks.instutil.wizard.ContextMenu;
import com.mathworks.instutil.wizard.ContextMenuListener;
import com.mathworks.instutil.wizard.TextComponentConfigurator;
import com.mathworks.instutil.wizard.TextComponentFactory;
import com.mathworks.instutil.wizard.TextComponentFactoryImpl;
import com.mathworks.instwiz.InstWizardIntf;
import com.mathworks.instwiz.PrintableEditorPane;
import com.mathworks.instwiz.PrivacyPolicyLabel;
import com.mathworks.instwiz.SwingComponentFactory;
import com.mathworks.instwiz.WIEditorPane;
import com.mathworks.instwiz.WILabel;
import com.mathworks.instwiz.arch.ArchGui;
import com.mathworks.instwiz.resources.ComponentName;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JToolTip;
import javax.swing.text.JTextComponent;

public final class WISwingComponentFactory
implements SwingComponentFactory {
    private final JPopupMenu contextMenu;
    private final ContextMenuListener listener;
    private final InstWizardIntf instWizard;
    private final TextComponentFactory textComponentFactory;
    private final TextComponentConfigurator textComponentConfigurator;

    public WISwingComponentFactory(ArchGui archGui, InstWizardIntf instWizardIntf) {
        this.instWizard = instWizardIntf;
        this.contextMenu = new ContextMenu();
        this.listener = new ContextMenuListener(this.contextMenu);
        TextComponentFactoryImpl textComponentFactoryImpl = this.createTextComponentFactory(archGui);
        this.textComponentFactory = textComponentFactoryImpl;
        this.textComponentConfigurator = textComponentFactoryImpl;
    }

    @Override
    public JPasswordField createPasswordField(ComponentName componentName) {
        JPasswordField jPasswordField = new JPasswordField();
        this.textComponentConfigurator.configureTextComponent((JTextComponent)jPasswordField, (MouseListener)this.listener, this.contextMenu);
        jPasswordField.setName(componentName.toString());
        return jPasswordField;
    }

    @Override
    public JTextComponent createTextArea(ComponentName componentName) {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        this.textComponentConfigurator.configureTextComponent((JTextComponent)jTextArea, (MouseListener)this.listener, this.contextMenu);
        jTextArea.setName(componentName.toString());
        return jTextArea;
    }

    @Override
    public JComponent createPrivacyPolicyLabel(InstWizardIntf instWizardIntf) {
        return new PrivacyPolicyLabel(instWizardIntf, true);
    }

    @Override
    public JTextComponent createLabel(String string) {
        return new WILabel(string, this.contextMenu, (MouseListener)this.listener);
    }

    @Override
    public JTextComponent createLabelNonWrapping(String string) {
        return new WILabel(string, false, this.contextMenu, (MouseListener)this.listener);
    }

    @Override
    public JTextComponent createLabelNonWrappingNonAccessible(String string) {
        return new WILabel(string, false, this.contextMenu, (MouseListener)this.listener, false);
    }

    @Override
    public JPopupMenu getContextMenu() {
        return this.contextMenu;
    }

    @Override
    public MouseListener getContextMenuListener() {
        return this.listener;
    }

    @Override
    public PrintableEditorPane createPrintableEditorPane(InstWizardIntf instWizardIntf, String string, ComponentName componentName) {
        PrintableEditorPane printableEditorPane = new PrintableEditorPane(instWizardIntf, string, this.contextMenu, (MouseListener)this.listener);
        printableEditorPane.setName(componentName.toString());
        return printableEditorPane;
    }

    @Override
    public JEditorPane createWIEditorPane(InstWizardIntf instWizardIntf, String string, ComponentName componentName) {
        WIEditorPane wIEditorPane = new WIEditorPane(instWizardIntf, string);
        wIEditorPane.setName(componentName.toString());
        return wIEditorPane;
    }

    @Override
    public JRadioButton createRadioButton(String string, ComponentName componentName) {
        JRadioButton jRadioButton = new JRadioButton(string);
        jRadioButton.setName(componentName.toString());
        return jRadioButton;
    }

    @Override
    public JCheckBox createCheckBox(String string, ComponentName componentName) {
        JCheckBox jCheckBox = new JCheckBox(string);
        jCheckBox.setName(componentName.toString());
        return jCheckBox;
    }

    @Override
    public JComponent createImageComponent(Icon icon, ComponentName componentName) {
        JLabel jLabel = new JLabel(icon);
        jLabel.setName(componentName.toString());
        return jLabel;
    }

    @Override
    public JToolTip createToolTipText(String string, ComponentName componentName) {
        JToolTip jToolTip = new JToolTip();
        jToolTip.setName(componentName.toString());
        jToolTip.setToolTipText(string);
        return jToolTip;
    }

    @Override
    public JComponent createFieldAndButtonWidget(JComponent jComponent, JComponent jComponent2) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jComponent, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)jComponent2, gridBagConstraints);
        return jPanel;
    }

    @Override
    public JComponent createFixedSizeFieldWidget(JComponent jComponent) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        jPanel.add((Component)jComponent, "West");
        return jPanel;
    }

    public void configureTextComponent(JTextComponent jTextComponent, MouseListener mouseListener, JPopupMenu jPopupMenu) {
        this.textComponentConfigurator.configureTextComponent(jTextComponent, mouseListener, jPopupMenu);
    }

    public void setupSelectAllOnFocusListener(JTextComponent jTextComponent) {
        this.textComponentConfigurator.setupSelectAllOnFocusListener(jTextComponent);
    }

    public void enableDragAndDrop(JComponent jComponent, JTextComponent jTextComponent) {
        this.textComponentConfigurator.enableDragAndDrop(jComponent, jTextComponent);
    }

    public JTextComponent createActivationKeyField(com.mathworks.instutil.wizard.ComponentName componentName, String string) {
        return this.textComponentFactory.createActivationKeyField(componentName, string);
    }

    public JTextComponent createPortNumberField(com.mathworks.instutil.wizard.ComponentName componentName, String string) {
        return this.textComponentFactory.createPortNumberField(componentName, string);
    }

    public JTextComponent createSerialNumberField(com.mathworks.instutil.wizard.ComponentName componentName, String string) {
        return this.textComponentFactory.createSerialNumberField(componentName, string);
    }

    public JTextComponent createTextField(com.mathworks.instutil.wizard.ComponentName componentName, String string) {
        return this.textComponentFactory.createTextField(componentName, string);
    }

    public JTextComponent createPasswordField(com.mathworks.instutil.wizard.ComponentName componentName) {
        return this.textComponentFactory.createPasswordField(componentName);
    }

    private TextComponentFactoryImpl createTextComponentFactory(ArchGui archGui) {
        return new TextComponentFactoryImpl(this.instWizard.getExceptionHandler(), archGui.getSelectAllBehavior());
    }
}

