/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instwiz;

import com.mathworks.instutil.FontHandler;
import com.mathworks.instutil.InstUtilResourceBundle;
import com.mathworks.instutil.wizard.WizardPaintFactory;
import com.mathworks.instwiz.Flippable;
import com.mathworks.instwiz.InstWizardIntf;
import com.mathworks.instwiz.WIButton;
import com.mathworks.instwiz.WICardPanel;
import com.mathworks.instwiz.WILayoutFocusTraversalPolicy;
import com.mathworks.instwiz.WINavigationPanelBuilder;
import com.mathworks.instwiz.WIPanelBuilder;
import com.mathworks.instwiz.WIPanelBuilderImpl;
import com.mathworks.instwiz.WISilentTimer;
import com.mathworks.instwiz.resources.ComponentName;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public abstract class WIPanel
extends JPanel
implements Flippable {
    private final InstWizardIntf app;
    private final Font boldFont;
    private final int space;
    private JButton fDefault;
    private Component fFocus;
    private String fTitle;
    private Flippable fPreviousPanel;
    private int maxButtonWidth;
    private int buttonHeight;

    protected WIPanel(InstWizardIntf instWizardIntf, ComponentName componentName) {
        this(instWizardIntf, componentName, new BorderLayout());
    }

    protected WIPanel(InstWizardIntf instWizardIntf, ComponentName componentName, LayoutManager layoutManager) {
        super(layoutManager);
        FontHandler fontHandler = instWizardIntf.getFontHandler();
        FontUIResource fontUIResource = fontHandler.getFont();
        this.boldFont = fontUIResource.deriveFont(1);
        this.app = instWizardIntf;
        this.space = WIPanel.getSpace(instWizardIntf);
        String string = componentName.toString();
        this.setName(string);
        this.setFocusTraversalPolicy(new WILayoutFocusTraversalPolicy());
        this.setFocusCycleRoot(true);
        this.setOpaque(false);
    }

    public static int getSpace(InstWizardIntf instWizardIntf) {
        InstUtilResourceBundle instUtilResourceBundle = instWizardIntf.getResources();
        return Integer.parseInt(instUtilResourceBundle.getString("space"));
    }

    public static Insets getTextFieldInsets(InstWizardIntf instWizardIntf) {
        InstUtilResourceBundle instUtilResourceBundle = instWizardIntf.getResources();
        int n = Integer.parseInt(instUtilResourceBundle.getString("top"));
        int n2 = Integer.parseInt(instUtilResourceBundle.getString("left"));
        int n3 = Integer.parseInt(instUtilResourceBundle.getString("bottom"));
        int n4 = Integer.parseInt(instUtilResourceBundle.getString("right"));
        return new Insets(n, n2, n3, n4);
    }

    @Override
    public final void flipForwardTo(Flippable flippable) {
        this.fPreviousPanel = flippable;
        this.display();
    }

    @Override
    public final void flipBackTo() {
        this.display();
    }

    private void display() {
        Object object;
        this.preDisplay();
        WICardPanel wICardPanel = this.app.getCardPanel();
        wICardPanel.selectPanel(this);
        this.postDisplay();
        if (this.fDefault != null) {
            object = this.app.getRootPane();
            ((JRootPane)object).setDefaultButton(this.fDefault);
        }
        if (this.fFocus != null && this.fFocus.isEnabled()) {
            this.fFocus.requestFocusInWindow();
        } else {
            object = this.getFocusTraversalPolicy();
            Component component = ((FocusTraversalPolicy)object).getComponentAfter(this, this.fFocus);
            while (!component.isEnabled() && !component.equals(this.fFocus)) {
                component = ((FocusTraversalPolicy)object).getComponentAfter(this, component);
            }
            component.requestFocusInWindow();
        }
        this.app.setTitle(this.fTitle);
    }

    public void back() {
        this.fPreviousPanel.flipBackTo();
    }

    protected final void setDefaults(JButton jButton, Component component, String string) {
        this.fDefault = jButton;
        this.fFocus = component;
        this.fTitle = string;
    }

    protected final JPanel layoutButtons(JButton[] jButtonArray) {
        WINavigationPanelBuilder wINavigationPanelBuilder = this.createNavigationPanelBuilder();
        this.addRightButtons(jButtonArray, wINavigationPanelBuilder);
        return wINavigationPanelBuilder.buildNavigationPanel(true);
    }

    private void addRightButtons(JButton[] jButtonArray, WINavigationPanelBuilder wINavigationPanelBuilder) {
        this.resizeButtons(jButtonArray);
        wINavigationPanelBuilder.addRightAnchoredButtons(jButtonArray);
    }

    private void resizeButtons(AbstractButton ... abstractButtonArray) {
        for (AbstractButton abstractButton : abstractButtonArray) {
            this.resizeButton(abstractButton);
        }
    }

    private void resizeButton(AbstractButton abstractButton) {
        abstractButton.setPreferredSize(new Dimension(this.getMaxButtonWidth(), this.getButtonHeight(abstractButton)));
    }

    private int getButtonHeight(AbstractButton abstractButton) {
        Dimension dimension = abstractButton.getPreferredSize();
        this.buttonHeight = dimension.height;
        return this.buttonHeight;
    }

    private WINavigationPanelBuilder createNavigationPanelBuilder() {
        return new WINavigationPanelBuilder(this.createMainImageLabel(), this.createFooterImageLabel());
    }

    protected final JPanel layoutButtons(JButton[] jButtonArray, JButton[] jButtonArray2) {
        WINavigationPanelBuilder wINavigationPanelBuilder = this.createNavigationPanelBuilder();
        this.addCenterButtons(jButtonArray, wINavigationPanelBuilder);
        this.addRightButtons(jButtonArray2, wINavigationPanelBuilder);
        return wINavigationPanelBuilder.buildNavigationPanel(true);
    }

    private void addCenterButtons(JButton[] jButtonArray, WINavigationPanelBuilder wINavigationPanelBuilder) {
        this.resizeButtons(jButtonArray);
        wINavigationPanelBuilder.addLeftAnchoredButtons(jButtonArray);
    }

    protected final ImageIcon getImageForPath(String string) {
        ClassLoader classLoader = WIPanel.class.getClassLoader();
        URL uRL = classLoader.getResource(string);
        if (uRL == null) {
            return new ImageIcon();
        }
        return new ImageIcon(uRL);
    }

    protected final String getInput() {
        byte[] byArray = new byte[256];
        int n = 0;
        try {
            n = System.in.read(byArray);
        }
        catch (Throwable throwable) {
            this.app.exception(throwable, false);
        }
        String string = new String(byArray, 0, n);
        return string.trim();
    }

    protected final void doSilent() {
        if (!(this.app.isInteractive() && !this.app.isCommandLine() || this.app.isCancelled())) {
            new WISilentTimer(this.app);
        }
    }

    public InstWizardIntf getApp() {
        return this.app;
    }

    protected final Font getBoldFont() {
        return this.boldFont;
    }

    public abstract JButton getNextButton();

    public void preDisplay() {
    }

    public void postDisplay() {
    }

    public final int getSpace() {
        return this.space;
    }

    public final InstUtilResourceBundle getResources() {
        return this.app.getResources();
    }

    private int getMaxButtonWidth() {
        if (this.maxButtonWidth == 0) {
            InstUtilResourceBundle instUtilResourceBundle = this.app.getResources();
            for (String string : this.getBottomButtonTextResourceKeys()) {
                String string2 = instUtilResourceBundle.getString(string);
                WIButton wIButton = new WIButton(this.app, string2, 0, "", new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                    }
                });
                int n = wIButton.getPreferredSize().width;
                if (n <= this.maxButtonWidth) continue;
                this.maxButtonWidth = n;
            }
        }
        return this.maxButtonWidth;
    }

    protected Collection<String> getBottomButtonTextResourceKeys() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("button.next");
        arrayList.add("button.back");
        arrayList.add("button.cancel");
        arrayList.add("button.finish");
        return arrayList;
    }

    protected final String getTitle() {
        return this.fTitle;
    }

    @Override
    protected final void paintComponent(Graphics graphics) {
        Paint paint;
        Paint paint2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = this.buttonHeight + 2 * this.space;
        int n2 = this.getHeight() - n;
        if (this.app.highContrast()) {
            paint = paint2 = (Paint)UIManager.get("Panel.background");
        } else {
            paint2 = WizardPaintFactory.createBackgroundPaint((int)n2);
            paint = WizardPaintFactory.createNavigationBackgroundPaint((int)this.getWidth());
        }
        Paint paint3 = graphics2D.getPaint();
        graphics2D.setPaint(paint2);
        int n3 = this.getWidth();
        graphics2D.fillRect(0, 0, n3, n2);
        graphics2D.setPaint(paint);
        graphics2D.fillRect(0, n2, n3, n);
        graphics2D.setPaint(paint3);
        super.paintComponent(graphics);
    }

    protected final WIPanelBuilder createPanelBuilder() {
        return new WIPanelBuilderImpl(this.createMainImageLabel(), this.createPrivacyPolicyLabel());
    }

    protected JComponent createPrivacyPolicyLabel() {
        return this.app.getSwingComponentFactory().createPrivacyPolicyLabel(this.app);
    }

    private JComponent createMainImageLabel() {
        return this.getImageLabel(ImageResourceRetriever.MAIN_IMAGE.getString());
    }

    private JComponent createFooterImageLabel() {
        return this.getImageLabel(ImageResourceRetriever.FOOTER_IMAGE.getString());
    }

    private JComponent getImageLabel(String string) {
        InstUtilResourceBundle instUtilResourceBundle = this.app.getResources();
        String string2 = instUtilResourceBundle.getString(string);
        return new JLabel(this.getImageForPath(string2));
    }

    public static enum ImageResourceRetriever {
        MAIN_IMAGE,
        FOOTER_IMAGE;

        private static final Map<ImageResourceRetriever, String> dpi_100;
        private static final Map<ImageResourceRetriever, String> dpi_125;
        private static final Map<ImageResourceRetriever, String> dpi_150;
        private static final Map<ImageResourceRetriever, String> dpi_200;
        private static final Map<ImageResourceRetriever, String> dpi_250;

        public String getString() {
            int n = Toolkit.getDefaultToolkit().getScreenResolution();
            String string = n <= 96 ? dpi_100.get((Object)this) : (n <= 120 ? dpi_125.get((Object)this) : (n <= 144 ? dpi_150.get((Object)this) : dpi_200.get((Object)this)));
            return string;
        }

        static {
            dpi_100 = new HashMap<ImageResourceRetriever, String>();
            dpi_125 = new HashMap<ImageResourceRetriever, String>();
            dpi_150 = new HashMap<ImageResourceRetriever, String>();
            dpi_200 = new HashMap<ImageResourceRetriever, String>();
            dpi_250 = new HashMap<ImageResourceRetriever, String>();
            dpi_100.put(MAIN_IMAGE, "image.main.100");
            dpi_100.put(FOOTER_IMAGE, "image.footer.100");
            dpi_125.put(MAIN_IMAGE, "image.main.125");
            dpi_125.put(FOOTER_IMAGE, "image.footer.125");
            dpi_150.put(MAIN_IMAGE, "image.main.150");
            dpi_150.put(FOOTER_IMAGE, "image.footer.150");
            dpi_200.put(MAIN_IMAGE, "image.main.200");
            dpi_200.put(FOOTER_IMAGE, "image.footer.200");
        }
    }
}

