/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instwiz;

import com.mathworks.instutil.FolderUtilsImpl;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class WILogger
extends Logger {
    private String logDir = System.getProperty("java.io.tmpdir");
    private static final String DEFAULT_LOG_NAME = "mathworks";
    private String fileName = "mathworks";
    private FileHandler fHandler = null;
    private ArrayList<LogRecord> logRecordQueue = new ArrayList(10);

    public WILogger() {
        this("com.mathworks.instwiz.InstWizard");
    }

    public WILogger(String string) {
        this(string, DEFAULT_LOG_NAME);
    }

    public WILogger(String string, String string2) {
        super(string, null);
        this.fileName = string2 + "_" + System.getProperty("user.name") + ".log";
        this.setLevel(Level.INFO);
    }

    WILogger(String string, File file) {
        super(string, null);
        this.fileName = file.getName();
        this.logDir = this.getParentAndCreateIfNotPresent(file);
        this.setLevel(Level.INFO);
    }

    private String getParentAndCreateIfNotPresent(File file) {
        String string = new FolderUtilsImpl().getParent(file);
        if (!new File(string).isDirectory()) {
            new File(string).mkdir();
        }
        return string;
    }

    public void start(String string) {
        if (this.fHandler != null) {
            this.fHandler.close();
            this.removeHandler(this.fHandler);
        }
        try {
            this.fHandler = new FileHandler(this.getLogPath(), true);
            this.fHandler.setFormatter(new WizardLogFormatter());
            this.addHandler(this.fHandler);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        while (!this.logRecordQueue.isEmpty()) {
            LogRecord logRecord = this.logRecordQueue.remove(0);
            super.log(logRecord);
        }
        this.info(string);
    }

    public boolean isStarted() {
        return this.fHandler != null;
    }

    public void setLogPath(String string) {
        File file = new File(string);
        this.logDir = this.getParentAndCreateIfNotPresent(file);
        this.fileName = file.getName();
    }

    public String getLogPath() {
        return new File(this.logDir, this.fileName).getAbsolutePath();
    }

    public void setLevel(String string) throws SecurityException {
        Level level = this.getLevel();
        if (string == null) {
            level = null;
        } else {
            try {
                int n = new Integer(string);
                if (n == 0) {
                    level = Level.INFO;
                } else if (n == 1) {
                    level = Level.FINE;
                } else if (n >= 2) {
                    level = Level.FINER;
                }
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    level = Level.parse(string.toUpperCase());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        if (this.getLevel() != level) {
            this.setLevel(level);
        }
    }

    @Override
    public final void config(String string) {
        this.log(Level.CONFIG, string);
    }

    @Override
    public final void fine(String string) {
        this.log(Level.FINE, string);
    }

    @Override
    public final void finer(String string) {
        this.log(Level.FINER, string);
    }

    @Override
    public final void finest(String string) {
        this.log(Level.FINEST, string);
    }

    @Override
    public final void info(String string) {
        this.log(Level.INFO, string);
    }

    @Override
    public void log(Level level, String string) {
        String string2 = System.getProperty("line.separator");
        String string3 = string.replaceAll("<br>", string2);
        string3 = string3.replaceAll("<[^<>]*>", "");
        if (this.isStarted()) {
            super.log(level, string3);
        } else {
            this.logRecordQueue.add(new LogRecord(level, string3));
        }
    }

    @Override
    public final void severe(String string) {
        this.log(Level.SEVERE, string);
    }

    @Override
    public final void warning(String string) {
        this.log(Level.WARNING, string);
    }

    public void exit() {
        Handler[] handlerArray;
        for (Handler handler : handlerArray = this.getHandlers()) {
            handler.close();
            this.removeHandler(handler);
        }
    }

    private static final class WizardLogFormatter
    extends Formatter {
        private WizardLogFormatter() {
        }

        @Override
        public String format(LogRecord logRecord) {
            String string = logRecord.getMessage();
            MessageFormat messageFormat = new MessageFormat(string);
            Object[] objectArray = logRecord.getParameters();
            string = messageFormat.format(objectArray);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("(MMM dd, yyyy HH:mm:ss)");
            String string2 = simpleDateFormat.format(new Date());
            String string3 = System.getProperty("line.separator");
            return string2.concat(string + string3);
        }
    }
}

