/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instwiz;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;

final class WIFocusTraversalPolicy
extends FocusTraversalPolicy {
    private final ArrayList<Component> components = new ArrayList(8);
    private Component fLastFocused;
    private final FocusListener fFocusListener = new CustomFocusListener();

    WIFocusTraversalPolicy() {
    }

    protected void finalize() throws Throwable {
        for (Component component : this.components) {
            component.removeFocusListener(this.fFocusListener);
        }
        super.finalize();
    }

    public void addComponent(Component component) {
        if (component != null) {
            int n = this.components.indexOf(component);
            if (n < 0) {
                component.addFocusListener(this.fFocusListener);
            } else {
                this.components.remove(n);
            }
            this.components.add(component);
        }
    }

    public void addComponents(Component[] componentArray) {
        if (componentArray != null) {
            for (Component component : componentArray) {
                this.addComponent(component);
            }
        }
    }

    @Override
    public Component getComponentAfter(Container container, Component component) {
        Component component2 = this.fLastFocused;
        int n = this.components.indexOf(component);
        if (n > -1) {
            do {
                if (n >= this.components.size() - 1) {
                    n = 0;
                    continue;
                }
                ++n;
            } while ((!(component2 = this.components.get(n)).isShowing() || !component2.isEnabled()) && !component2.equals(component));
        }
        if (!(component2 == null || component2.isShowing() && component2.isEnabled())) {
            component2 = null;
        }
        return component2;
    }

    @Override
    public Component getComponentBefore(Container container, Component component) {
        Component component2 = this.fLastFocused;
        int n = this.components.indexOf(component);
        if (n > -1) {
            do {
                if (n == 0) {
                    n = this.components.size() - 1;
                    continue;
                }
                --n;
            } while ((!(component2 = this.components.get(n)).isShowing() || !component2.isEnabled()) && !component2.equals(component));
        }
        if (!(component2 == null || component2.isShowing() && component2.isEnabled())) {
            component2 = null;
        }
        return component2;
    }

    @Override
    public Component getDefaultComponent(Container container) {
        return this.components.size() > 0 ? this.components.get(0) : null;
    }

    @Override
    public Component getFirstComponent(Container container) {
        return this.components.size() > 0 ? this.components.get(0) : null;
    }

    @Override
    public Component getLastComponent(Container container) {
        int n = this.components.size() - 1;
        return n > -1 ? this.components.get(n) : null;
    }

    private class CustomFocusListener
    extends FocusAdapter {
        private CustomFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            WIFocusTraversalPolicy.this.fLastFocused = focusEvent.getComponent();
        }
    }
}

