/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instwiz;

import com.mathworks.instutil.InstUtilResourceBundle;
import com.mathworks.instutil.wizard.SizedColumnLicenseTable;
import com.mathworks.instwiz.WIPanel;
import com.mathworks.mlwebservices.Account;
import com.mathworks.mlwebservices.InstallerEntitlement;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class LicenseTable
extends SizedColumnLicenseTable {
    private final Map<Integer, String> fColumnMap = new HashMap<Integer, String>();
    private Account fAccount;
    private List<InstallerEntitlement> fLicenses;
    private final String fLicenseNumberColumnLabel;
    private final String fLicenseOptionColumnLabel;
    private final String fLicenseLabelColumnLabel;
    private final String fLicenseOptionPattern;

    public LicenseTable(WIPanel wIPanel, Account account) {
        InstUtilResourceBundle instUtilResourceBundle = wIPanel.getResources();
        this.fLicenseNumberColumnLabel = instUtilResourceBundle.getString("licsel.column0");
        this.fColumnMap.put(0, this.fLicenseNumberColumnLabel);
        this.fLicenseLabelColumnLabel = instUtilResourceBundle.getString("licsel.column1");
        this.fColumnMap.put(1, this.fLicenseLabelColumnLabel);
        this.fLicenseOptionColumnLabel = instUtilResourceBundle.getString("licsel.column2");
        this.fColumnMap.put(2, this.fLicenseOptionColumnLabel);
        this.fLicenseOptionPattern = instUtilResourceBundle.getString("licenseoption");
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                LicenseTable.this.repaint();
            }
        });
        JTableHeader jTableHeader = this.getTableHeader();
        TableCellRenderer tableCellRenderer = jTableHeader.getDefaultRenderer();
        JLabel jLabel = (JLabel)((Object)tableCellRenderer);
        jLabel.setHorizontalAlignment(2);
        this.setSelectionMode(0);
        this.setAccount(account);
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        Component component = focusEvent.getOppositeComponent();
        if (!(focusEvent.getID() != 1004 || component != null && ((Object)((Object)this)).equals(component.getParent()) || this.getRowCount() <= 0 || this.getColumnCount() <= 0 || this.getSelectedRows().length != 0 || this.getSelectedColumns().length != 0)) {
            this.setColumnSelectionInterval(0, 0);
            this.setRowSelectionInterval(0, 0);
        }
    }

    public final void setAccount(Account account) {
        this.fAccount = account;
        LicenseTableModel licenseTableModel = new LicenseTableModel();
        this.setModel(licenseTableModel);
        InstallerEntitlement installerEntitlement = account.getSelectedEntitlement();
        if (installerEntitlement != null) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                InstallerEntitlement installerEntitlement2 = this.fLicenses.get(i);
                if (!installerEntitlement2.equals(installerEntitlement)) continue;
                this.setRowSelectionInterval(i, i);
            }
        } else if (this.getRowCount() > 0) {
            this.setRowSelectionInterval(0, 0);
        }
        this.sizeTableColumnsToContents();
    }

    public String getEntitlementIdAtRow(int n) {
        String string;
        if (n < this.fLicenses.size()) {
            InstallerEntitlement installerEntitlement = this.fLicenses.get(n);
            string = installerEntitlement.getId();
        } else {
            string = "";
        }
        return string;
    }

    public InstallerEntitlement getSelectedEntitlement() {
        InstallerEntitlement installerEntitlement = null;
        int n = this.getSelectedRow();
        if (n > -1) {
            installerEntitlement = this.fLicenses.get(n);
        }
        return installerEntitlement;
    }

    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Component component = super.prepareRenderer(tableCellRenderer, n, n2);
        boolean bl = this.isEnabled();
        component.setEnabled(bl);
        return component;
    }

    private final class LicenseTableModel
    extends AbstractTableModel {
        private LicenseTableModel() {
            LicenseTable.this.fLicenses = LicenseTable.this.fAccount.getEntitlements();
        }

        @Override
        public String getColumnName(int n) {
            return (String)LicenseTable.this.fColumnMap.get(n);
        }

        @Override
        public int getRowCount() {
            return LicenseTable.this.fLicenses.size();
        }

        @Override
        public int getColumnCount() {
            return LicenseTable.this.fColumnMap.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            InstallerEntitlement installerEntitlement = (InstallerEntitlement)LicenseTable.this.fLicenses.get(n);
            String string = (String)LicenseTable.this.fColumnMap.get(n2);
            String string2 = string.equalsIgnoreCase(LicenseTable.this.fLicenseNumberColumnLabel) ? (installerEntitlement.isTSUREntitlement() ? installerEntitlement.getId() : installerEntitlement.getLicenseNumber()) : (string.equalsIgnoreCase(LicenseTable.this.fLicenseOptionColumnLabel) ? installerEntitlement.getDisplayLabelForEntitlement() : (string.equalsIgnoreCase(LicenseTable.this.fLicenseLabelColumnLabel) ? installerEntitlement.getUserDefinedLabel() : null));
            return string2;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            Object object = this.getValueAt(0, n);
            Class<?> clazz = object != null ? object.getClass() : super.getColumnClass(n);
            return clazz;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

