/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instwiz;

import com.mathworks.instutil.ExecutorServiceManagerImpl;
import com.mathworks.instutil.FontHandler;
import com.mathworks.instutil.FontHandlerImpl;
import com.mathworks.instutil.InstUtilExceptionHandler;
import com.mathworks.instutil.InstUtilResourceBundle;
import com.mathworks.instutil.InstallerUtilities;
import com.mathworks.instutil.WaitObject;
import com.mathworks.instutil.hyperlink.InstallAndLicensingHyperlinkProvider;
import com.mathworks.instutil.services.ServiceThread;
import com.mathworks.instutil.services.ServiceThreadFactory;
import com.mathworks.instutil.services.ServiceThreadFactoryImpl;
import com.mathworks.instutil.wizard.EscapeHandlerImpl;
import com.mathworks.instwiz.ButtonFactory;
import com.mathworks.instwiz.InstWizardIntf;
import com.mathworks.instwiz.InstwizProxyAuthenticationUI;
import com.mathworks.instwiz.SwingComponentFactory;
import com.mathworks.instwiz.WIButtonFactory;
import com.mathworks.instwiz.WICardPanel;
import com.mathworks.instwiz.WILogger;
import com.mathworks.instwiz.WIOptionPane;
import com.mathworks.instwiz.WIResourceBundle;
import com.mathworks.instwiz.WISwingComponentFactory;
import com.mathworks.instwiz.WIUncaughtExceptionHandler;
import com.mathworks.instwiz.arch.ArchGui;
import com.mathworks.instwiz.arch.ArchGuiFactoryImpl;
import com.mathworks.instwiz.services.ServiceDialog;
import com.mathworks.net.hyperlink.HyperlinkProvider;
import com.mathworks.net.transport.MWTransportClientProperties;
import com.mathworks.net.transport.MWTransportClientPropertiesFactory;
import com.mathworks.webproxy.ProxyAuthenticationUI;
import com.mathworks.webproxy.ProxyConfiguration;
import com.mathworks.webproxy.WebproxyFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.synth.SynthLookAndFeel;
import org.apache.commons.io.IOUtils;

public abstract class InstWizard
extends JFrame
implements InstWizardIntf {
    private final WICardPanel fCardPanel = new WICardPanel();
    private final boolean fSetLookAndFeel;
    private final boolean fWaitForFinish;
    private final WaitObject waitObject = new WaitObject();
    private final WIUncaughtExceptionHandler fExceptionHandler;
    private final MWTransportClientProperties tcp = MWTransportClientPropertiesFactory.create((String)"http");
    private final ExecutorServiceManagerImpl executorServiceManager = new ExecutorServiceManagerImpl();
    private final ServiceThreadFactoryImpl serviceThreadFactory = new ServiceThreadFactoryImpl();
    private final ArchGui archGui;
    private final SwingComponentFactory swingComponentFactory;
    private final Map<String, Object> uiPropertyResetMap = new HashMap<String, Object>();
    private InstUtilResourceBundle res;
    private WILogger logger = new WILogger();
    private boolean interactive = true;
    private boolean commandLine = false;
    private boolean verbose = false;
    private boolean fVisibleFlag = true;
    private int timeOut = 1000;
    private int fServiceTimeOut = 0;
    private boolean cancelled = false;
    private ButtonFactory buttonFactory;
    private ServiceDialog currentServiceDialog;
    private FontHandler fontHandler;

    public InstWizard() {
        this(new ArchGuiFactoryImpl().create());
    }

    public InstWizard(ArchGui archGui) {
        this(archGui, new WIResourceBundle(archGui), true, true);
    }

    public InstWizard(InstUtilResourceBundle instUtilResourceBundle, boolean bl, boolean bl2) {
        this(new ArchGuiFactoryImpl().create(), instUtilResourceBundle, bl, bl2);
    }

    private InstWizard(ArchGui archGui, InstUtilResourceBundle instUtilResourceBundle, boolean bl, boolean bl2) {
        this.archGui = archGui;
        this.res = instUtilResourceBundle;
        this.res.setExceptionHandler((InstUtilExceptionHandler)this);
        this.fSetLookAndFeel = bl;
        this.fWaitForFinish = bl2;
        this.fExceptionHandler = new WIUncaughtExceptionHandler(this);
        this.fExceptionHandler.initialize();
        if (this.fSetLookAndFeel) {
            try {
                String string = UIManager.getSystemLookAndFeelClassName();
                if (!SynthLookAndFeel.class.isAssignableFrom(Class.forName(string))) {
                    UIManager.setLookAndFeel(string);
                }
            }
            catch (Exception exception) {
                this.exception(exception, false);
            }
        }
        this.swingComponentFactory = new WISwingComponentFactory(this.archGui, this);
        this.pack();
        this.setDefaultCloseOperation(0);
        new EscapeHandlerImpl().setUpEscapeKey((RootPaneContainer)this, (Window)this);
    }

    public void setUpIcon() {
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        ArrayList<Image> arrayList = new ArrayList<Image>();
        arrayList.add(new ImageIcon(classLoader.getResource(this.res.getString("icon.16"))).getImage());
        arrayList.add(new ImageIcon(classLoader.getResource(this.res.getString("icon.32"))).getImage());
        arrayList.add(new ImageIcon(classLoader.getResource(this.res.getString("icon.48"))).getImage());
        this.setIconImages(arrayList);
    }

    @Override
    public void showGUI() {
        if (!this.isVisible() && !this.commandLine && this.fVisibleFlag) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    InstWizard.this.setVisible(true);
                    InstWizard.this.toFront();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                new Thread(runnable).start();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    protected final void setupGUI(ProxyConfiguration proxyConfiguration) {
        Object object;
        Object object2;
        if (this.fSetLookAndFeel) {
            this.fontHandler = new FontHandlerImpl();
            object2 = this.fontHandler.getFont();
            if (this.highContrast()) {
                object2 = new FontUIResource(((Font)object2).deriveFont(1));
            } else {
                object = this.archGui.getArchSpecificUIProperties();
                for (String string : object.keySet()) {
                    this.storeInitialUIManagerPropertyState(string);
                    UIManager.put(string, object.get(string));
                }
            }
            object = new ArrayList();
            object.add("EditorPane.font");
            object.add("OptionPane.font");
            object.add("OptionPane.messageFont");
            object.add("OptionPane.buttonFont");
            object.add("Panel.font");
            object.add("RadioButton.font");
            object.add("CheckBox.font");
            object.add("TextField.font");
            object.add("TableHeader.font");
            object.add("Table.font");
            object.add("ScrollPane.font");
            object.add("Label.font");
            object.add("TextArea.font");
            object.add("Button.font");
            object.add("TitledBorder.font");
            object.add("PasswordField.font");
            object.add("ComboBox.font");
            object.add("Menu.font");
            object.add("ListBox.font");
            object.add("MenuItem.font");
            Iterator<Object> iterator = object.iterator();
            while (iterator.hasNext()) {
                String string;
                string = (String)iterator.next();
                this.storeInitialUIManagerPropertyState(string);
                UIManager.getDefaults().put(string, object2);
            }
            this.storeInitialUIManagerPropertyState("TitledBorder.titleColor");
            UIManager.put("TitledBorder.titleColor", Color.BLACK);
            this.storeInitialUIManagerPropertyState("Table.focusCellHighlightBorder");
            UIManager.put("Table.focusCellHighlightBorder", UIManager.get("Table.selectionBackground"));
            this.storeInitialUIManagerPropertyState("FileChooser.cancelButtonText");
            UIManager.put("FileChooser.cancelButtonText", this.res.getString("button.cancel.nomnemonic"));
        } else {
            this.fontHandler = new FontHandlerImpl();
        }
        this.sizeAndPosition();
        object2 = new InstwizProxyAuthenticationUI(this, this.swingComponentFactory);
        object = WebproxyFactory.createProxyAuthenticator();
        object.setAsDefault(proxyConfiguration, (ProxyAuthenticationUI)object2);
    }

    private void storeInitialUIManagerPropertyState(String string) {
        this.uiPropertyResetMap.put(string, UIManager.get(string));
    }

    private void resetUIManager() {
        for (String string : this.uiPropertyResetMap.keySet()) {
            UIManager.put(string, this.uiPropertyResetMap.get(string));
        }
    }

    private void sizeAndPosition() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int n;
                int n2;
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                Dimension dimension = toolkit.getScreenSize();
                int n3 = dimension.height;
                int n4 = dimension.width;
                Insets insets = InstWizard.this.getInsets();
                try {
                    n2 = InstWizard.getFrameWidth(InstWizard.this.fontHandler, insets);
                    n = InstWizard.getFrameHeight(InstWizard.this.fontHandler, insets);
                }
                catch (Exception exception) {
                    InstWizard.this.exception(exception, false);
                    return;
                }
                if (n3 < n) {
                    n = n3;
                }
                if (n4 < n2) {
                    n2 = n4;
                }
                JScrollPane jScrollPane = new JScrollPane(InstWizard.this.fCardPanel);
                jScrollPane.setBorder(null);
                InstWizard.this.add(jScrollPane);
                Dimension dimension2 = new Dimension(n2 - insets.left - insets.right, n - insets.top - insets.bottom);
                InstWizard.this.fCardPanel.setPreferredSize(dimension2);
                InstWizard.this.pack();
                InstWizard.this.setLocationOfFrameToCenter();
            }
        };
        this.doNowOnEDT(runnable);
    }

    private void setLocationOfFrameToCenter() {
        super.setLocationRelativeTo(null);
    }

    public static int getFrameWidth(FontHandler fontHandler, Insets insets) {
        return fontHandler.getSize(635) + insets.left + insets.right;
    }

    public static int getFrameHeight(FontHandler fontHandler, Insets insets) {
        return fontHandler.getSize(375) + insets.top + insets.bottom - 23;
    }

    @Override
    public ArchGui getArchGui() {
        return this.archGui;
    }

    @Override
    public final boolean isInteractive() {
        return this.interactive;
    }

    protected final void setInteractive(boolean bl) {
        this.interactive = bl;
    }

    @Override
    public final boolean isVerbose() {
        return this.verbose;
    }

    public final void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public final WILogger getLogger() {
        return this.logger;
    }

    protected final void setLogger(WILogger wILogger) {
        if (this.logger != null) {
            this.logger.exit();
        }
        this.logger = wILogger;
    }

    public ExecutorService getExecutor() {
        return this.executorServiceManager.getMultiThreadedExecutorService();
    }

    protected void exit() {
        this.disposeAndCloseLog(0);
    }

    protected final void disposeAndCloseLog(int n) {
        String string = System.getProperty("line.separator");
        Object[] objectArray = new Object[]{Integer.toString(n)};
        String string2 = this.res.getString("log.end") + string + string;
        this.logger.log(Level.INFO, string2, objectArray);
        this.logger.exit();
        this.executorServiceManager.shutdownAndAwaitTermination();
        this.setVisible(false);
        this.resetUIManager();
        this.resetExceptionHandler();
        this.dispose();
    }

    private void resetExceptionHandler() {
        this.fExceptionHandler.exit();
    }

    public final void exception(Throwable throwable) {
        this.exception(throwable, false);
    }

    public final void exception(final Throwable throwable, final boolean bl) {
        final InstWizard instWizard = this;
        this.doNowOnEDT(new Runnable(){

            @Override
            public void run() {
                Throwable string4;
                Object object;
                String string = "";
                StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
                String string2 = System.getProperty("line.separator");
                if (stackTraceElementArray != null) {
                    for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                        object = stackTraceElement.toString() + string2;
                        string = string.concat((String)object);
                    }
                }
                String string3 = throwable.toString();
                String string5 = throwable.getMessage();
                if (string5 == null && null != (string4 = throwable.getCause())) {
                    string5 = string4.getMessage();
                }
                String string6 = string5 == null ? string3 + string2 + string : string3 + string2 + string5 + string2 + string;
                InstWizard.this.logger.log(Level.SEVERE, string6);
                if (InstWizard.this.isInteractive() && !InstWizard.this.isCommandLine() && !bl) {
                    String string7 = InstWizard.this.res.getString("exception.msg");
                    object = new MessageFormat(string7);
                    String string8 = InstWizard.this.logger.getLogPath();
                    String string9 = ((Format)object).format(new Object[]{string5, string8});
                    String string10 = InstWizard.this.res.getString("exception.title");
                    WIOptionPane.show(instWizard, string9, string10, 0, -1);
                } else if (InstWizard.this.isCommandLine()) {
                    System.out.println(string5 + string2 + string);
                }
            }
        });
    }

    @Override
    public final boolean isCommandLine() {
        return this.commandLine;
    }

    public final void setCommandLine(boolean bl) {
        this.commandLine = bl;
    }

    @Override
    public final InstUtilResourceBundle getResources() {
        return this.res;
    }

    public final void setResources(WIResourceBundle wIResourceBundle) {
        this.res = wIResourceBundle;
    }

    @Override
    public final int getTimeout() {
        return this.timeOut;
    }

    public final void setTimeout(String string) {
        try {
            this.timeOut = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = this.res.getString("ini.timeout.invalid");
            MessageFormat messageFormat = new MessageFormat(string2);
            Object[] objectArray = new Object[]{string, Integer.toString(this.timeOut)};
            String string3 = messageFormat.format(objectArray);
            this.logger.warning(string3);
        }
    }

    @Override
    public final void setServiceTimeout(String string) {
        try {
            this.fServiceTimeOut = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = this.res.getString("ini.timeout.invalid");
            MessageFormat messageFormat = new MessageFormat(string2);
            Object[] objectArray = new Object[]{string, Integer.toString(this.fServiceTimeOut)};
            String string3 = messageFormat.format(objectArray);
            this.logger.warning(string3);
        }
    }

    @Override
    public final HyperlinkProvider getHyperlinkProvider() {
        return new InstallAndLicensingHyperlinkProvider(){

            protected String getClientIdentifier() {
                return InstWizard.this.getHyperlinkClientIdentifier();
            }
        };
    }

    protected abstract String getHyperlinkClientIdentifier();

    @Override
    public final int getServiceTimeout() {
        return this.fServiceTimeOut;
    }

    @Override
    public final WICardPanel getCardPanel() {
        return this.fCardPanel;
    }

    @Override
    public final void cancel() {
        this.cancelled = true;
        if (this.fWaitForFinish) {
            this.waitObject.stopwaiting();
        } else {
            this.exit();
        }
    }

    @Override
    public final void done() {
        if (this.fWaitForFinish) {
            this.waitObject.stopwaiting();
        } else {
            this.exit();
        }
    }

    @Override
    public final boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public final FontHandler getFontHandler() {
        return this.fontHandler;
    }

    protected final void waitUntilDone() {
        if (this.fWaitForFinish) {
            this.waitObject.waitUntilNotifiedofCompletion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Map<String, String> parseIniFile(File file) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(fileInputStream);
            Enumeration<String> enumeration = propertyResourceBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                String string2 = propertyResourceBundle.getString(string);
                hashMap.put(string, string2);
            }
        }
        catch (Throwable throwable) {
            try {
                this.exception(throwable, false);
            }
            catch (Throwable throwable2) {
                IOUtils.closeQuietly(fileInputStream);
                throw throwable2;
            }
            IOUtils.closeQuietly((InputStream)fileInputStream);
        }
        IOUtils.closeQuietly((InputStream)fileInputStream);
        return hashMap;
    }

    @Override
    public ButtonFactory getButtonFactory() {
        if (this.buttonFactory == null) {
            this.buttonFactory = new WIButtonFactory(this);
        }
        return this.buttonFactory;
    }

    public void setButtonFactory(ButtonFactory buttonFactory) {
        this.buttonFactory = buttonFactory;
    }

    @Override
    public boolean getVisibleFlag() {
        return this.fVisibleFlag;
    }

    @Override
    public void setVisibleFlag(boolean bl) {
        this.fVisibleFlag = bl;
    }

    @Override
    public WIUncaughtExceptionHandler getExceptionHandler() {
        return this.fExceptionHandler;
    }

    public void log(Level level, String string) {
        this.logger.log(level, string);
    }

    public void logSevere(String string) {
        this.logger.severe(string);
    }

    public void logWarning(String string) {
        this.logger.warning(string);
    }

    public void logInfo(String string) {
        this.logger.info(string);
    }

    public void logFine(String string) {
        this.logger.fine(string);
    }

    @Override
    public boolean highContrast() {
        return this.getArchGui().isHighContrast(this, this.getMachineInfo());
    }

    public String getClientString() {
        return InstallerUtilities.getClientVersion((InstUtilResourceBundle)this.res, (String)"client.string");
    }

    public String intlString(String string) {
        return this.res.getString(string);
    }

    public void serviceCallStarted(final ServiceThread<?> serviceThread, final String string, final String string2) {
        final InstWizard instWizard = this;
        this.doNowOnEDT(new Runnable(){

            @Override
            public void run() {
                InstWizard.this.currentServiceDialog = new ServiceDialog(instWizard, serviceThread, string, string2);
                if (InstWizard.this.getVisibleFlag()) {
                    InstWizard.this.currentServiceDialog.setVisible(true);
                }
            }
        });
    }

    @Override
    public void doNowOnEDT(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
                this.exception(interruptedException, true);
            }
            catch (InvocationTargetException invocationTargetException) {
                this.exception(invocationTargetException, true);
            }
        }
    }

    public void serviceCallRunning() {
        this.doNowOnEDT(new Runnable(){

            @Override
            public void run() {
                if (InstWizard.this.currentServiceDialog != null && InstWizard.this.getVisibleFlag()) {
                    InstWizard.this.currentServiceDialog.setVisible(true);
                }
            }
        });
    }

    public void serviceCallDone() {
        this.doNowOnEDT(new Runnable(){

            @Override
            public void run() {
                if (InstWizard.this.currentServiceDialog != null && InstWizard.this.currentServiceDialog.isShowing()) {
                    InstWizard.this.currentServiceDialog.setVisible(false);
                    InstWizard.this.currentServiceDialog.dispose();
                }
            }
        });
    }

    public void error(final String string, final String string2) {
        final InstWizard instWizard = this;
        this.doNowOnEDT(new Runnable(){

            @Override
            public void run() {
                if (InstWizard.this.currentServiceDialog != null && InstWizard.this.currentServiceDialog.isShowing()) {
                    InstWizard.this.currentServiceDialog.setVisible(false);
                    InstWizard.this.currentServiceDialog.dispose();
                }
                WIOptionPane.show(instWizard, string2, string, 0, -1);
            }
        });
    }

    public void warning(final String string, final String string2) {
        final InstWizard instWizard = this;
        this.doNowOnEDT(new Runnable(){

            @Override
            public void run() {
                if (InstWizard.this.currentServiceDialog != null && InstWizard.this.currentServiceDialog.isShowing()) {
                    InstWizard.this.currentServiceDialog.setVisible(false);
                    InstWizard.this.currentServiceDialog.dispose();
                }
                WIOptionPane.show(instWizard, string2, string, 2, -1);
            }
        });
    }

    public void uncaughtException(final Thread thread, final Throwable throwable) {
        this.doNowOnEDT(new Runnable(){

            @Override
            public void run() {
                InstWizard.this.fExceptionHandler.uncaughtException(thread, throwable);
            }
        });
    }

    @Override
    public MWTransportClientProperties getTransportClientProperties() {
        return this.tcp;
    }

    @Override
    public int showPanel(String string, String string2, int n, int n2) {
        return WIOptionPane.show((InstWizardIntf)this, string, string2, n, n2);
    }

    @Override
    public int showPanel(String string, String string2, int n, int n2, int n3) {
        return WIOptionPane.show(this, string, string2, n, n2, n3);
    }

    @Override
    public int showPanel(Component component, String string, int n, int n2) {
        return WIOptionPane.show((InstWizardIntf)this, component, string, n, n2);
    }

    @Override
    public ServiceThreadFactory getServiceThreadFactory() {
        return this.serviceThreadFactory;
    }

    @Override
    public JFrame getFrame() {
        return this;
    }

    @Override
    public int showDialog(JFileChooser jFileChooser, String string) {
        return jFileChooser.showDialog(this, string);
    }

    @Override
    public JDialog createDialog(JOptionPane jOptionPane, String string) {
        return jOptionPane.createDialog(this, string);
    }

    @Override
    public void setLocationRelativeTo(JDialog jDialog) {
        jDialog.setLocationRelativeTo(this);
    }

    @Override
    public SwingComponentFactory getSwingComponentFactory() {
        return this.swingComponentFactory;
    }

    @Override
    public void removeAllWindowListeners() {
        WindowListener[] windowListenerArray;
        for (WindowListener windowListener : windowListenerArray = this.getWindowListeners()) {
            this.removeWindowListener(windowListener);
        }
    }
}

