/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil.wizard;

import com.mathworks.instutil.wizard.WizardNavigationPanelBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class AbstractNavigationPanelBuilder<T extends WizardNavigationPanelBuilder<T>>
implements WizardNavigationPanelBuilder<T> {
    private List<AbstractButton> leftButtons = new ArrayList<AbstractButton>();
    private List<AbstractButton> rightButtons = new ArrayList<AbstractButton>();

    @Override
    public T addLeftAnchoredButtons(AbstractButton ... abstractButtonArray) {
        this.leftButtons.addAll(Arrays.asList(abstractButtonArray));
        return this.getThis();
    }

    protected abstract T getThis();

    @Override
    public T addRightAnchoredButtons(AbstractButton ... abstractButtonArray) {
        this.rightButtons.addAll(Arrays.asList(abstractButtonArray));
        return this.getThis();
    }

    @Override
    public JPanel buildNavigationPanel(boolean bl) {
        JComponent jComponent;
        JPanel jPanel = this.createPanel(new BorderLayout());
        JPanel jPanel2 = this.createNavigationBackgroundPanel();
        jPanel.add((Component)jPanel2, "Center");
        if (bl) {
            jComponent = this.createImage();
            jPanel2.add((Component)jComponent, "East");
        } else {
            jComponent = new JLabel(new ImageIcon());
            jPanel2.add((Component)this.alignImage(jComponent), "East");
        }
        jComponent = this.createButtonPanel();
        jPanel2.add((Component)jComponent, "Center");
        return jPanel;
    }

    protected abstract JPanel createNavigationBackgroundPanel();

    protected abstract JPanel createPanel(LayoutManager var1);

    private JComponent createImage() {
        return this.alignImage(this.createFooterImage());
    }

    protected abstract JComponent createFooterImage();

    private JComponent alignImage(JComponent jComponent) {
        JComponent jComponent2 = this.createMainImage();
        int n = (jComponent2.getPreferredSize().width - jComponent.getPreferredSize().width - 10) / 2;
        jComponent.setBorder(BorderFactory.createEmptyBorder(0, n, 0, 10 + n));
        return jComponent;
    }

    protected abstract JComponent createMainImage();

    private JPanel createButtonPanel() {
        JPanel jPanel = this.createPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 2;
        for (AbstractButton object : this.rightButtons) {
            if (!object.isVisible()) continue;
            --n;
        }
        int n2 = 2;
        for (AbstractButton abstractButton : this.leftButtons) {
            if (!abstractButton.isVisible()) continue;
            --n2;
        }
        if (n == 2 && n2 == 1) {
            List<AbstractButton> list = this.leftButtons;
            this.leftButtons = this.rightButtons;
            this.rightButtons = list;
            n2 = 2;
            n = 1;
        }
        gridBagConstraints.insets = new Insets(10, 5, 10, 5);
        for (AbstractButton abstractButton : this.leftButtons) {
            if (!abstractButton.isVisible()) continue;
            jPanel.add((Component)abstractButton, gridBagConstraints);
        }
        this.addPaddingLabels(jPanel, n2, this.leftButtons, gridBagConstraints);
        this.leftButtons.clear();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        if (n2 >= 0) {
            this.addPaddingLabels(jPanel, n, this.rightButtons, gridBagConstraints);
        }
        for (AbstractButton abstractButton : this.rightButtons) {
            if (!abstractButton.isVisible()) continue;
            jPanel.add((Component)abstractButton, gridBagConstraints);
            gridBagConstraints.weightx = 0.0;
        }
        this.rightButtons.clear();
        return jPanel;
    }

    private void addPaddingLabels(JPanel jPanel, int n, List<AbstractButton> list, GridBagConstraints gridBagConstraints) {
        Dimension dimension;
        Dimension dimension2 = dimension = list.size() > 0 ? list.get(0).getPreferredSize() : new Dimension(95, 25);
        for (int i = n; i > 0; --i) {
            JLabel jLabel = new JLabel("");
            jLabel.setPreferredSize(dimension);
            jPanel.add((Component)jLabel, gridBagConstraints);
        }
    }
}

