/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil.services;

import com.mathworks.instutil.services.AwsActivationServiceThread;
import com.mathworks.instutil.services.ServiceThreadState;
import com.mathworks.instutil.services.ServiceThreadView;
import com.mathworks.internal.mwaws.client.v6.ArrayOfMWAEntitlement;
import com.mathworks.internal.mwaws.client.v6.ArrayOfMWMessage;
import com.mathworks.internal.mwaws.client.v6.MWAEntitlement;
import com.mathworks.internal.mwaws.client.v6.MWAGetEntitlementsResponse;
import com.mathworks.internal.mwaws.client.v6.MWAResponse;
import com.mathworks.internal.mwaws.client.v6.MWMessage;
import com.mathworks.mlwebservices.ActivationService;
import com.mathworks.mlwebservices.InstallerEntitlement;
import com.mathworks.mlwebservices.InstallerEntitlementFactoryImpl;
import java.util.ArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class EntitlementListRetrievalThread
extends AwsActivationServiceThread<InstallerEntitlement[]> {
    private ArrayList<InstallerEntitlement> entitlements;
    private final String token;
    private final Lock lock = new ReentrantLock();

    EntitlementListRetrievalThread(ServiceThreadView serviceThreadView, ActivationService activationService, String string) {
        super(serviceThreadView, activationService, "dialog.title", "dialog.license");
        this.token = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block22: {
            ActivationService activationService = this.getActivationService();
            String string = this.getClientString();
            this.entitlements = new ArrayList();
            try {
                MWMessage[] mWMessageArray;
                MWAGetEntitlementsResponse mWAGetEntitlementsResponse = activationService.getEntitlements(this.token, string);
                ServiceThreadState serviceThreadState = this.processResponse((MWAResponse)mWAGetEntitlementsResponse);
                this.setStatus(serviceThreadState);
                if (this.getStatus() == ServiceThreadState.SUCCESS) {
                    this.lock.lock();
                    try {
                        ArrayOfMWAEntitlement arrayOfMWAEntitlement = mWAGetEntitlementsResponse.getEntitlements();
                        if (arrayOfMWAEntitlement != null && arrayOfMWAEntitlement.getEntitlement() != null) {
                            for (MWAEntitlement mWAEntitlement : arrayOfMWAEntitlement.getEntitlement()) {
                                this.entitlements.add(InstallerEntitlementFactoryImpl.createInstallerEntitlement((MWAEntitlement)mWAEntitlement));
                            }
                        }
                        break block22;
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
                ArrayOfMWMessage arrayOfMWMessage = mWAGetEntitlementsResponse.getMessages();
                if (arrayOfMWMessage != null && (mWMessageArray = arrayOfMWMessage.getMessage()) != null) {
                    for (MWMessage mWMessage : mWMessageArray) {
                        if (mWMessage.getCode() != 676) continue;
                        this.setStatus(ServiceThreadState.SUCCESS);
                    }
                }
            }
            catch (Throwable throwable) {
                this.handleThrowable(throwable);
            }
            finally {
                if (this.isCancelled()) {
                    this.lock.lock();
                    try {
                        this.entitlements = null;
                    }
                    finally {
                        this.lock.unlock();
                    }
                } else {
                    this.finish();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InstallerEntitlement[] getResult() {
        InstallerEntitlement[] installerEntitlementArray;
        this.lock.lock();
        try {
            installerEntitlementArray = this.entitlements.toArray(new InstallerEntitlement[this.entitlements.size()]);
        }
        finally {
            this.lock.unlock();
        }
        return installerEntitlementArray;
    }
}

