/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil.licensefiles;

import com.mathworks.instutil.JNIException;
import com.mathworks.instutil.NativeUtility;
import com.mathworks.instutil.PlatformImpl;
import com.mathworks.instutil.licensefiles.LicenseFileExt;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class LicenseUtil
extends NativeUtility {
    public LicenseUtil(String string) throws JNIException {
        super(string);
    }

    public String getUserLicensePath() {
        return LicenseUtil.nativeGetUserLicensePath();
    }

    public static String getMatchingUserLoginNameForUserLockingString(String string, String string2) {
        String string3 = "";
        if (string.length() != 0) {
            String string4 = string2.trim();
            try {
                if (LicenseUtil.getUserLockingString(string4).equalsIgnoreCase(string)) {
                    string3 = string4;
                } else if (new PlatformImpl().isWindows()) {
                    if (LicenseUtil.getUserLockingString(string4.toUpperCase()).equalsIgnoreCase(string)) {
                        string3 = string4.toUpperCase();
                    }
                    if (LicenseUtil.getUserLockingString(string4.toLowerCase()).equalsIgnoreCase(string)) {
                        string3 = string4.toLowerCase();
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return string3;
    }

    public static ArrayList<File> getLicenseFilesFromPath(String string) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (string != null) {
            String[] stringArray;
            String string2 = File.pathSeparator;
            for (String string3 : stringArray = string.split(string2)) {
                if (string3.contains("@")) continue;
                if (LicenseUtil.isLicFile(string3)) {
                    File file = new File(string3);
                    if (!file.isFile()) continue;
                    arrayList.add(file);
                    continue;
                }
                if (string3.length() == 0) continue;
                boolean bl = false;
                File file = null;
                try {
                    file = new File(string3);
                    bl = file.isDirectory();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!bl) continue;
                try {
                    File[] fileArray = file.listFiles(new LicFileFilter());
                    if (fileArray == null || fileArray.length <= 0) continue;
                    List<File> list = Arrays.asList(fileArray);
                    arrayList.addAll(list);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
        return arrayList;
    }

    public static String getUserLockingString(String string) {
        String string2 = string.trim();
        StringBuilder stringBuilder = new StringBuilder("");
        for (int i = 0; i < string2.length(); ++i) {
            stringBuilder.append(Integer.toHexString(string2.codePointAt(i)));
        }
        return stringBuilder.toString();
    }

    static boolean isLicFile(String string) {
        for (LicenseFileExt licenseFileExt : LicenseFileExt.values()) {
            if (!(new PlatformImpl().isWindows() ? string.toLowerCase().endsWith(licenseFileExt.getExt()) : string.endsWith(licenseFileExt.getExt()))) continue;
            return true;
        }
        return false;
    }

    private static native String nativeGetUserLicensePath();

    static class LicFileFilter
    implements FilenameFilter {
        LicFileFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            boolean bl = LicenseUtil.isLicFile(string);
            if (bl) {
                File file2 = new File(file, string);
                return file2.isFile();
            }
            return bl;
        }
    }
}

