/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil;

import com.mathworks.mlwebservices.BaseOptionsConfigurator;
import com.mathworks.mlwebservices.webproxy.ProxyOptionsConfigurator;
import com.mathworks.webproxy.ProxyConfiguration;
import java.util.Properties;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.Stub;

abstract class WebServiceProxy<T extends Stub> {
    private T inner;
    private final ProxyConfiguration proxyConfiguration;
    private final Properties props;

    WebServiceProxy(ProxyConfiguration proxyConfiguration, Properties properties) {
        this.proxyConfiguration = proxyConfiguration;
        this.props = properties;
    }

    protected T getInner() throws AxisFault {
        if (this.inner == null) {
            this.getNewInner();
        }
        return this.inner;
    }

    protected T getNewInner() throws AxisFault {
        this.inner = this.createStubInstance();
        this.configureOptions();
        return this.inner;
    }

    protected abstract T createStubInstance() throws AxisFault;

    protected abstract String getPropertyKey();

    protected abstract String getDefaultEndpointURL();

    private void configureOptions() {
        Options options = this.inner._getServiceClient().getOptions();
        String string = this.getEndpointURL();
        new BaseOptionsConfigurator(string, this.getTimeOut()).configureOptions(options);
        new ProxyOptionsConfigurator(this.proxyConfiguration, string).configureOptions(options);
    }

    private long getTimeOut() {
        long l;
        try {
            String string = this.props.getProperty("wsTimeout", String.valueOf(20000));
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            l = 20000L;
        }
        return l;
    }

    private String getEndpointURL() {
        return this.props.getProperty(this.getPropertyKey(), this.getDefaultEndpointURL());
    }
}

