/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil;

import com.mathworks.instutil.InstUtilExceptionHandler;
import com.mathworks.instutil.InstUtilPropertyKey;
import com.mathworks.instutil.InstUtilResourceBundle;
import com.mathworks.instutil.MachineInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import javax.swing.SwingUtilities;

public class InstallerUtilities {
    private InstallerUtilities() {
    }

    public static String getOsVersionString() {
        return System.getProperty("os.name") + ' ' + System.getProperty("os.version") + ' ' + System.getProperty("os.arch");
    }

    public static String getClientVersion(InstUtilResourceBundle instUtilResourceBundle) {
        return InstallerUtilities.getClientVersion(instUtilResourceBundle, "client.string");
    }

    public static String getClientVersion(InstUtilResourceBundle instUtilResourceBundle, String string) {
        return InstallerUtilities.getClientString(instUtilResourceBundle.getString(string), instUtilResourceBundle.getString("releasenum.text"));
    }

    public static String getClientString(String string, String string2) {
        return string + '-' + string2;
    }

    public static String getRootFolderForLib(Properties properties) {
        String string = properties.getProperty(InstUtilPropertyKey.LIBDIR.get());
        if (string == null) {
            string = properties.getProperty(InstUtilPropertyKey.ROOTDIR.get());
        }
        return string;
    }

    public static String getLibDirPath(String string) {
        String string2 = string;
        if (!string.endsWith(File.separator)) {
            string2 = string.concat(File.separator);
        }
        String string3 = MachineInfo.getArch();
        return string2 + "bin" + File.separator + string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileIntoString(String string, InstUtilExceptionHandler instUtilExceptionHandler) {
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = null;
        try {
            String string2;
            bufferedReader = new BufferedReader(new FileReader(string));
            String string3 = System.getProperty("line.separator");
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2).append(string3);
            }
        }
        catch (IOException iOException) {
            instUtilExceptionHandler.exception(iOException);
            String string4 = null;
            return string4;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return stringBuilder.toString();
    }

    public static void doNowOnEDT(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException | InvocationTargetException exception) {
                // empty catch block
            }
        }
    }
}

