/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil;

import com.mathworks.instutil.DefaultSecurityOverrideImpl;
import com.mathworks.instutil.FilePermissions;
import com.mathworks.instutil.FilePermissionsUtil;
import com.mathworks.instutil.FolderUtils;
import com.mathworks.instutil.JNIException;
import com.mathworks.instutil.NoParentException;
import com.mathworks.instutil.ParentFolderOperation;
import com.mathworks.instutil.SecurityOverride;
import java.io.File;
import java.io.IOException;

public final class FolderUtilsImpl
implements FolderUtils {
    private final FilePermissions filePermissions;
    private final SecurityOverride securityOverride;

    public FolderUtilsImpl(FilePermissions filePermissions, SecurityOverride securityOverride) {
        this.filePermissions = filePermissions;
        this.securityOverride = securityOverride;
    }

    public FolderUtilsImpl() {
        this(new FilePermissionsUtil(), new DefaultSecurityOverrideImpl());
    }

    @Override
    public String scrub(String string) {
        char c = File.separatorChar;
        String string2 = string.trim();
        string2 = FolderUtilsImpl.removeDoubleSeparatorsWithSingleSeparators(c, string2);
        string2 = FolderUtilsImpl.removeLeadingAndTrailingDoubleQuotes(string2);
        string2 = FolderUtilsImpl.ensureTrailingSlashAndTrimSpaceBeforeLastSlash(c, string2);
        string2 = FolderUtilsImpl.ensureSlashFollowsColon(c, string2);
        return string2;
    }

    @Override
    public boolean isAbsolute(String string) {
        return string != null && new File(string).isAbsolute();
    }

    @Override
    public boolean exists(String string) {
        return string != null && new File(string).exists();
    }

    @Override
    public boolean canWriteToFolder(String string) {
        return string != null && FolderUtilsImpl.canWriteTempFileToFolder(new File(string));
    }

    @Override
    public boolean mkdirs(String string) {
        File file = new File(string);
        this.createParentIfNecessary(file);
        file.mkdir();
        if (!file.exists()) {
            this.mkdirAsCurrentUser(file);
        }
        return file.isDirectory();
    }

    @Override
    public void createParentIfNecessary(File file) {
        if (this.hasParent(file)) {
            File file2 = this.getParentFile(file);
            file2.mkdirs();
            if (!file2.exists()) {
                this.mkdirAsCurrentUser(file2);
            }
            if (!file.canWrite()) {
                try {
                    this.filePermissions.setFileWritable(file, true);
                }
                catch (JNIException jNIException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public File getParentFile(File file) {
        if (this.hasParent(file)) {
            return file.getParentFile();
        }
        throw new NoParentException(file);
    }

    @Override
    public boolean hasParent(File file) {
        return file.getParentFile() != null;
    }

    @Override
    public boolean canWriteToParent(File file) {
        return this.canWriteToFolder(this.getParent(file));
    }

    @Override
    public void recursivelyOperateOnFileAndParents(File file, File file2, ParentFolderOperation parentFolderOperation) {
        File file3 = this.getParentFile(file);
        parentFolderOperation.execute(file);
        while (!file3.equals(file2)) {
            parentFolderOperation.execute(file3);
            file3 = this.getParentFile(file3);
        }
    }

    @Override
    public boolean firstExistingDirectoryExists(File file) {
        try {
            this.getFirstExistingDirectory(file);
            return true;
        }
        catch (NoParentException noParentException) {
            return false;
        }
    }

    @Override
    public File getFirstExistingDirectory(File file) {
        File file2 = file;
        while (!file2.isDirectory()) {
            file2 = this.getParentFile(file2);
        }
        return file2;
    }

    @Override
    public File getSearchPathForFileBrowser(File file, File file2) {
        File file3 = file;
        while (file3 != null && !file3.isDirectory()) {
            try {
                file3 = this.getParentFile(file3);
            }
            catch (NoParentException noParentException) {
                file3 = file2;
            }
        }
        return file3;
    }

    private void mkdirAsCurrentUser(File file) {
        if (!file.exists()) {
            String string = System.getProperty("user.name");
            this.mkdirAsUser(file.getAbsolutePath(), string);
        }
    }

    private boolean mkdirAsUser(String string, String string2) {
        return this.securityOverride.mkdirAsRoot(string, string2);
    }

    @Override
    public boolean mkdirAsRoot(String string) {
        return this.mkdirAsUser(string, "");
    }

    private static boolean canWriteTempFileToFolder(File file) {
        boolean bl;
        try {
            File file2 = File.createTempFile("test", ".txt", file);
            file2.delete();
            bl = true;
        }
        catch (IOException iOException) {
            bl = false;
        }
        return bl;
    }

    private static String ensureSlashFollowsColon(char c, String string) {
        if (string.length() > 2 && string.charAt(1) == ':' && string.charAt(2) != c && string.charAt(2) != '/') {
            return string.substring(0, 2) + File.separator + string.substring(2);
        }
        return string;
    }

    private static String ensureTrailingSlashAndTrimSpaceBeforeLastSlash(char c, String string) {
        String string2 = string.trim();
        int n = string2.length();
        if (n > 0) {
            int n2 = n - 1;
            String string3 = File.separator;
            if (string2.charAt(n2) != c) {
                string2 = string2 + string3;
            } else {
                string2 = string2.substring(0, n2);
                string2 = string2.trim();
                string2 = string2 + string3;
            }
        }
        return string2;
    }

    private static String removeLeadingAndTrailingDoubleQuotes(String string) {
        if (string.startsWith("\"") && string.endsWith("\"")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    private static String removeDoubleSeparatorsWithSingleSeparators(char c, String string) {
        String string2 = string;
        String string3 = File.separator + File.separator;
        int n = string2.indexOf(string3);
        while (n > 0) {
            StringBuffer stringBuffer = new StringBuffer(string2);
            if (stringBuffer.charAt(n) == c && stringBuffer.charAt(n + 1) == c) {
                stringBuffer = stringBuffer.deleteCharAt(n);
            }
            string2 = stringBuffer.toString();
            n = string2.indexOf(string3);
        }
        return string2;
    }

    @Override
    public String getParent(File file) {
        return this.getParentFile(file).getAbsolutePath();
    }

    @Override
    public String getDownloadFolder() {
        return this.getDownloadDirectory();
    }

    private native String getDownloadDirectory();
}

