/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.workflow.v2;

import com.mathworks.install.DownloaderBuilder;
import com.mathworks.install.DownloaderBuilderFactory;
import com.mathworks.installwizard.command.InstallCommandStepFactory;
import com.mathworks.installwizard.model.InstallModelFactory;
import com.mathworks.installwizard.model.InstallWizardContext;
import com.mathworks.installwizard.model.InstallWizardProperties;
import com.mathworks.installwizard.workflow.v2.AbstractBranchingInstallWorkflow;
import com.mathworks.installwizard.workflow.v2.InstallWorkflowFactory;
import com.mathworks.instutil.AvailablePlatform;
import com.mathworks.wizard.Workflow;
import com.mathworks.wizard.model.DefaultedModel;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.model.ModelImpl;
import com.mathworks.wizard.model.PlatformModel;
import com.mathworks.wizard.ui.panels.PanelStepBuilder;
import java.io.File;
import java.util.Arrays;
import java.util.Properties;

class ReadArchivesWorkflow
extends AbstractBranchingInstallWorkflow<String> {
    private String token;
    private InstallWizardContext installWizardContext;
    private DefaultedModel<File> downloadFolderModel;
    private Model<DownloaderBuilder> downloaderBuilderModel;
    private PlatformModel<AvailablePlatform> platformModel;
    private final DownloaderBuilder downloaderBuilder;

    public ReadArchivesWorkflow(InstallModelFactory installModelFactory, InstallCommandStepFactory installCommandStepFactory, String string, Properties properties, InstallWizardContext installWizardContext, DefaultedModel<File> defaultedModel, PlatformModel<AvailablePlatform> platformModel, InstallWorkflowFactory installWorkflowFactory, DownloaderBuilderFactory downloaderBuilderFactory, Model<String[]> model) {
        super(installModelFactory, installCommandStepFactory, installWorkflowFactory, properties);
        this.token = string;
        this.installWizardContext = installWizardContext;
        this.downloadFolderModel = defaultedModel;
        this.platformModel = platformModel;
        this.downloaderBuilder = downloaderBuilderFactory.createDownloaderBuilder(platformModel.getSelectedPlatforms(), (String[])model.get());
        this.downloaderBuilderModel = new ModelImpl();
    }

    @Override
    protected void construct(PanelStepBuilder panelStepBuilder, InstallCommandStepFactory installCommandStepFactory) {
        this.addStep(installCommandStepFactory.createStartReadingDownloadFolderArchives(this.downloadFolderModel, this.downloaderBuilderModel, this.downloaderBuilder));
    }

    @Override
    protected String evaluateWorkflow(InstallWizardProperties installWizardProperties) {
        return ((File)this.downloadFolderModel.get()).getAbsolutePath() + Arrays.toString(this.platformModel.getSelectedPlatforms());
    }

    @Override
    protected Workflow createNewBranch(InstallWorkflowFactory installWorkflowFactory, Properties properties) {
        return installWorkflowFactory.createDownloadOnlyWorkflow(this.token, properties, this.installWizardContext, this.downloadFolderModel, this.downloaderBuilderModel, this.platformModel);
    }
}

