/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.workflow.v2;

import com.mathworks.install.udc.UsageDataCollector;
import com.mathworks.install.udc.UsageDataCollectorKey;
import com.mathworks.installwizard.command.InstallCommandStepFactory;
import com.mathworks.installwizard.model.InstallModelFactory;
import com.mathworks.installwizard.model.InstallWizardProperties;
import com.mathworks.installwizard.workflow.v2.AbstractBranchingInstallWorkflow;
import com.mathworks.installwizard.workflow.v2.InstallWorkflowFactory;
import com.mathworks.internal.mwaws.client.v6.MWAEntitlement;
import com.mathworks.wizard.Workflow;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.model.ModelImpl;
import com.mathworks.wizard.ui.panels.PanelStepBuilder;
import java.util.Properties;

public final class LoginWorkflow
extends AbstractBranchingInstallWorkflow<String> {
    private static final MWAEntitlement[] EMPTY_ENTITLEMENT_ARRAY = new MWAEntitlement[0];
    private final Model<String> username;
    private final Model<String> password;
    private final Model<String> token;
    private final Model<MWAEntitlement[]> entitlements;
    private final Model<Boolean> adminSwitch;
    private final Model<Boolean> installSwitch;
    private final UsageDataCollector usageDataCollector;
    private final Model<Boolean> enableDLSwitch;
    private final Model<String> hasExcessEntitlements;

    LoginWorkflow(InstallModelFactory installModelFactory, InstallCommandStepFactory installCommandStepFactory, InstallWorkflowFactory installWorkflowFactory, String string, String string2, Properties properties, UsageDataCollector usageDataCollector, String string3) {
        super(installModelFactory, installCommandStepFactory, installWorkflowFactory, properties);
        this.usageDataCollector = usageDataCollector;
        this.username = new ModelImpl((Object)string);
        this.password = new ModelImpl((Object)string2);
        this.token = new ModelImpl();
        this.entitlements = new ModelImpl((Object)EMPTY_ENTITLEMENT_ARRAY);
        this.adminSwitch = new ModelImpl();
        this.installSwitch = installModelFactory.createInstallSwitch();
        this.enableDLSwitch = installModelFactory.createEnableDLSwitchModel(string3);
        this.hasExcessEntitlements = new ModelImpl((Object)"");
    }

    @Override
    protected void construct(PanelStepBuilder panelStepBuilder, InstallCommandStepFactory installCommandStepFactory) {
        this.addStep(installCommandStepFactory.createLoginStep(this.username, this.password, this.token));
        this.addStep(installCommandStepFactory.createGetEntitlementsStep(this.token, this.entitlements, this.hasExcessEntitlements));
        this.addStep(installCommandStepFactory.createIsDownloadOnlyPermissionAvailableStep(this.entitlements, this.adminSwitch, this.enableDLSwitch));
    }

    @Override
    protected String evaluateWorkflow(InstallWizardProperties installWizardProperties) {
        installWizardProperties.setToken((String)this.token.get());
        installWizardProperties.setEmail((String)this.username.get());
        StringBuilder stringBuilder = new StringBuilder();
        for (MWAEntitlement mWAEntitlement : (MWAEntitlement[])this.entitlements.get()) {
            stringBuilder.append(mWAEntitlement.getId());
        }
        return stringBuilder.toString();
    }

    @Override
    protected Workflow createNewBranch(InstallWorkflowFactory installWorkflowFactory, Properties properties) {
        this.usageDataCollector.addData(UsageDataCollectorKey.USAGE_DATA_TOKEN, this.token.get());
        if (((Boolean)this.adminSwitch.get()).booleanValue() || !((String)this.hasExcessEntitlements.get()).isEmpty()) {
            return installWorkflowFactory.createDownloadInstallWorkflow(properties, this.installSwitch, this.entitlements, this.token, this.hasExcessEntitlements);
        }
        this.usageDataCollector.addData(UsageDataCollectorKey.SESSION_DATA_DOWNLOAD_ONLY, (Object)false);
        if (this.foundEntitlements()) {
            return installWorkflowFactory.createEntitlementSelectionWorkflow((MWAEntitlement[])this.entitlements.get(), (String)this.token.get(), properties);
        }
        return installWorkflowFactory.createProvideActivationKeyWorkflow((String)this.token.get(), properties);
    }

    private boolean foundEntitlements() {
        return ((MWAEntitlement[])this.entitlements.get()).length > 0;
    }
}

