/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.workflow.v2;

import com.mathworks.install.udc.UsageDataCollector;
import com.mathworks.install.udc.UsageDataCollectorKey;
import com.mathworks.installwizard.command.InstallCommandStepFactory;
import com.mathworks.installwizard.model.InstallModelFactory;
import com.mathworks.installwizard.model.InstallWizardProperties;
import com.mathworks.installwizard.workflow.v2.AbstractBranchingInstallWorkflow;
import com.mathworks.installwizard.workflow.v2.InstallWorkflowFactory;
import com.mathworks.internal.mwaws.client.v6.MWAEntitlement;
import com.mathworks.wizard.Workflow;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.model.ModelImpl;
import com.mathworks.wizard.ui.panels.PanelStepBuilder;
import java.util.Properties;

final class HasActivationKeyWorkflow
extends AbstractBranchingInstallWorkflow<String> {
    private final Model<String> activationKey;
    private final Model<MWAEntitlement> entitlementModel;
    private final Model<String> tokenModel;
    private final UsageDataCollector usageDataCollector;

    HasActivationKeyWorkflow(InstallModelFactory installModelFactory, InstallCommandStepFactory installCommandStepFactory, InstallWorkflowFactory installWorkflowFactory, String string, String string2, Properties properties, UsageDataCollector usageDataCollector) {
        super(installModelFactory, installCommandStepFactory, installWorkflowFactory, properties);
        this.usageDataCollector = usageDataCollector;
        this.activationKey = new ModelImpl((Object)string);
        this.entitlementModel = new ModelImpl();
        this.tokenModel = new ModelImpl((Object)string2);
    }

    @Override
    protected void construct(PanelStepBuilder panelStepBuilder, InstallCommandStepFactory installCommandStepFactory) {
        this.addStep(installCommandStepFactory.createGetEntitlementByActivationKeyStep(this.tokenModel, this.activationKey, this.entitlementModel));
        this.addStep(installCommandStepFactory.createAssociateSelfStep(this.tokenModel, this.activationKey));
    }

    @Override
    protected String evaluateWorkflow(InstallWizardProperties installWizardProperties) {
        ((MWAEntitlement)this.entitlementModel.get()).setActivationKey((String)this.activationKey.get());
        installWizardProperties.setEntitlement((MWAEntitlement)this.entitlementModel.get());
        return ((MWAEntitlement)this.entitlementModel.get()).getId();
    }

    @Override
    protected Workflow createNewBranch(InstallWorkflowFactory installWorkflowFactory, Properties properties) {
        this.usageDataCollector.addData(UsageDataCollectorKey.USAGE_DATA_ACTIVATION_KEY_USED, (Object)true);
        this.usageDataCollector.addData(UsageDataCollectorKey.SESSION_DATA_ACTIVATION_KEY, this.activationKey.get());
        this.usageDataCollector.addData(UsageDataCollectorKey.USAGE_DATA_TOKEN, this.tokenModel.get());
        return installWorkflowFactory.createHasEntitlementWorkflow((MWAEntitlement)this.entitlementModel.get(), (String)this.tokenModel.get(), properties);
    }
}

