/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.workflow.v2;

import com.mathworks.install.Installer;
import com.mathworks.install.Product;
import com.mathworks.install.SoftwareManager;
import com.mathworks.install.ValidatedFik;
import com.mathworks.installwizard.command.InstallCommandStepFactory;
import com.mathworks.installwizard.model.InstallModelFactory;
import com.mathworks.installwizard.model.InstallWizardContext;
import com.mathworks.installwizard.model.InstallWizardProperties;
import com.mathworks.installwizard.workflow.v2.AbstractBranchingInstallWorkflow;
import com.mathworks.installwizard.workflow.v2.InstallWorkflowFactory;
import com.mathworks.wizard.Workflow;
import com.mathworks.wizard.model.DefaultedModel;
import com.mathworks.wizard.model.FileSystem;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.model.ModelImpl;
import com.mathworks.wizard.resources.WizardResourceKeys;
import com.mathworks.wizard.ui.panels.PanelStepBuilder;
import java.util.Properties;

final class FolderSelectionWorkflow
extends AbstractBranchingInstallWorkflow<String> {
    private final Installer install;
    private final DefaultedModel<String> installFolderModel;
    private final DefaultedModel<String> displayedFolderModel;
    private final FileSystem fileSystem;
    private final Model<String> licenseFileContentsModel = new ModelImpl();
    private ValidatedFik validatedFik;
    private InstallWizardContext installWizardContext;
    private final Model<Boolean> lnuOnly;

    FolderSelectionWorkflow(InstallModelFactory installModelFactory, InstallCommandStepFactory installCommandStepFactory, InstallWorkflowFactory installWorkflowFactory, Installer installer, Properties properties, ValidatedFik validatedFik, InstallWizardContext installWizardContext, Model<Boolean> model) {
        super(installModelFactory, installCommandStepFactory, installWorkflowFactory, properties);
        this.install = installer;
        this.validatedFik = validatedFik;
        this.installWizardContext = installWizardContext;
        this.lnuOnly = model;
        this.installFolderModel = installModelFactory.createInstallFolderModel((Product[])installer.getAvailableProducts());
        this.displayedFolderModel = installModelFactory.createDisplayedFolderModel(this.installFolderModel, (Product[])installer.getAvailableProducts());
        this.fileSystem = installModelFactory.createFileSystem((SoftwareManager)installer, this.installFolderModel);
    }

    @Override
    protected final void construct(PanelStepBuilder panelStepBuilder, InstallCommandStepFactory installCommandStepFactory) {
        this.addStep(panelStepBuilder.buildFolderSelectionStep(this.displayedFolderModel));
        this.addStep(installCommandStepFactory.resetAndDeselectOlderVersionsOfSelectedProducts(this.install));
        this.addStep(installCommandStepFactory.createCheckPathForNonEnglishCharactersStep(this.installFolderModel));
        this.addStep(installCommandStepFactory.createCheckPathForInvalidCharactersStep(this.displayedFolderModel));
        this.addStep(installCommandStepFactory.createVerifyRootDirectoryStep(this.installFolderModel));
        this.addStep(installCommandStepFactory.createCreateFolderIfItDoesNotAlreadyExistStep(this.installFolderModel));
        this.addStep(installCommandStepFactory.createCheckWritePermissionsStep(this.installFolderModel));
        this.addStep(installCommandStepFactory.createCheckIfOverwriteImpossibleStep(this.installFolderModel, this.install));
        this.addStep(installCommandStepFactory.createWarningMessageIfMATLABRunning(this.installFolderModel));
        this.addStep(installCommandStepFactory.createWarnIfNotEnoughAvailableSpaceStep(this.fileSystem));
    }

    @Override
    protected final String evaluateWorkflow(InstallWizardProperties installWizardProperties) {
        installWizardProperties.setRoot((String)this.installFolderModel.get());
        return this.getText();
    }

    @Override
    protected Workflow createNewBranch(InstallWorkflowFactory installWorkflowFactory, Properties properties) {
        return installWorkflowFactory.createPreProductSelectionWorkflow(properties, this.install, this.validatedFik, this.installWizardContext, this.installFolderModel, this.fileSystem, this.lnuOnly);
    }

    private String getText() {
        String string = System.getProperty("line.separator");
        return WizardResourceKeys.CONFIRM_DIR.getString(new Object[0]) + string + (String)this.installFolderModel.get() + string + string + WizardResourceKeys.CONFIRM_PRODUCTS.getString(new Object[0]) + string + (String)this.licenseFileContentsModel.get();
    }
}

