/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.workflow.v2;

import com.mathworks.install.AvailableProduct;
import com.mathworks.install.Downloader;
import com.mathworks.install.SoftwareManager;
import com.mathworks.install.udc.UsageDataCollector;
import com.mathworks.install.udc.UsageDataCollectorKey;
import com.mathworks.installwizard.command.InstallCommandStepFactory;
import com.mathworks.installwizard.model.InstallModelFactory;
import com.mathworks.installwizard.model.InstallWizardContext;
import com.mathworks.installwizard.model.InstallWizardProperties;
import com.mathworks.installwizard.workflow.v2.AbstractBranchingInstallWorkflow;
import com.mathworks.installwizard.workflow.v2.InstallWorkflowFactory;
import com.mathworks.instutil.AvailablePlatform;
import com.mathworks.wizard.Workflow;
import com.mathworks.wizard.model.DefaultedModel;
import com.mathworks.wizard.model.FileSystem;
import com.mathworks.wizard.model.ModelImpl;
import com.mathworks.wizard.model.PlatformModel;
import com.mathworks.wizard.model.ProductModel;
import com.mathworks.wizard.model.ProductTableFormat;
import com.mathworks.wizard.ui.panels.PanelStepBuilder;
import java.io.File;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Properties;

final class DownloadProductSelectionWorkflow
extends AbstractBranchingInstallWorkflow<String> {
    private final ProductModel<AvailableProduct> productModel;
    private final ProductTableFormat<AvailableProduct> productTableFormat;
    private final FileSystem fileSystem;
    private final DefaultedModel<File> downloadFolderModel;
    private final Downloader downloader;
    private final InstallWizardContext installWizardContext;
    private final UsageDataCollector usageDataCollector;
    private final PlatformModel<AvailablePlatform> selectedPlatforms;

    DownloadProductSelectionWorkflow(InstallModelFactory installModelFactory, InstallCommandStepFactory installCommandStepFactory, Downloader downloader, final DefaultedModel<File> defaultedModel, InstallWizardContext installWizardContext, Properties properties, InstallWorkflowFactory installWorkflowFactory, PlatformModel<AvailablePlatform> platformModel, UsageDataCollector usageDataCollector) {
        super(installModelFactory, installCommandStepFactory, installWorkflowFactory, properties);
        this.installWizardContext = installWizardContext;
        this.usageDataCollector = usageDataCollector;
        this.productModel = installModelFactory.createProductModel((SoftwareManager)downloader);
        Collection collection = this.productModel.getAvailable();
        for (AvailableProduct availableProduct : collection) {
            if (availableProduct.getDownloadSize() != 0L) continue;
            availableProduct.setSelected(false);
        }
        this.productTableFormat = installModelFactory.createDownloadProductTableFormat(this.productModel);
        this.downloadFolderModel = defaultedModel;
        this.downloader = downloader;
        this.fileSystem = installModelFactory.createFileSystem((SoftwareManager)downloader, new DefaultedModel<String>(){

            public String getDefault() {
                return ((File)defaultedModel.getDefault()).getAbsolutePath();
            }

            public String get() {
                return ((File)defaultedModel.get()).getAbsolutePath();
            }

            public void set(String string) {
                defaultedModel.set((Object)new File(string));
            }
        });
        this.selectedPlatforms = platformModel;
    }

    @Override
    protected void construct(PanelStepBuilder panelStepBuilder, InstallCommandStepFactory installCommandStepFactory) {
        this.addStep(installCommandStepFactory.createCheckIfNoProductsStep(new ModelImpl((Object)this.downloader)));
        this.addStep(installCommandStepFactory.createWarnIfNotEnoughAvailableSpaceStep(this.fileSystem));
        this.addStep(panelStepBuilder.buildDownloadProductSelectionStep(this.productModel, this.productTableFormat));
    }

    @Override
    protected String evaluateWorkflow(InstallWizardProperties installWizardProperties) {
        return this.installWizardContext.buildDownloadConfirmationText((File)this.downloadFolderModel.get(), this.downloader, this.selectedPlatforms);
    }

    @Override
    protected Workflow createNewBranch(InstallWorkflowFactory installWorkflowFactory, Properties properties) {
        this.collectUdcData();
        return installWorkflowFactory.createDownloadConfirmationPanelWorkflow(this.downloader, this.installWizardContext, this.downloadFolderModel, this.fileSystem, this.selectedPlatforms);
    }

    private void collectUdcData() {
        this.usageDataCollector.removeData(UsageDataCollectorKey.PRODUCT_DATA_CLEAR_PRODUCT_DATA);
        Collection collection = this.productModel.getAvailable();
        for (AvailableProduct availableProduct : collection) {
            EnumMap<UsageDataCollectorKey, Object> enumMap = new EnumMap<UsageDataCollectorKey, Object>(UsageDataCollectorKey.class);
            enumMap.put(UsageDataCollectorKey.PRODUCT_DATA_NAME, (Object)availableProduct.getName());
            enumMap.put(UsageDataCollectorKey.PRODUCT_DATA_VERSION, (Object)availableProduct.getVersion());
            enumMap.put(UsageDataCollectorKey.PRODUCT_DATA_BASE_CODE, (Object)availableProduct.getProductBaseCode());
            enumMap.put(UsageDataCollectorKey.PRODUCT_DATA_BIT_CODE, (Object)availableProduct.getProductNumber());
            enumMap.put(UsageDataCollectorKey.PRODUCT_DATA_SELECTED, (Object)availableProduct.isSelected());
            enumMap.put(UsageDataCollectorKey.PRODUCT_DATA_DOWNLOADABLE, (Object)(availableProduct.getDownloadSize() != 0L ? 1 : 0));
            this.usageDataCollector.addData(UsageDataCollectorKey.PRODUCT_DATA_ADD_PRODUCT_DATA, enumMap);
        }
    }
}

