/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.workflow.v2;

import com.mathworks.install.Downloader;
import com.mathworks.install.DownloaderBuilder;
import com.mathworks.installwizard.command.InstallCommandStepFactory;
import com.mathworks.installwizard.model.InstallModelFactory;
import com.mathworks.installwizard.model.InstallWizardContext;
import com.mathworks.installwizard.model.InstallWizardProperties;
import com.mathworks.installwizard.workflow.v2.AbstractBranchingInstallWorkflow;
import com.mathworks.installwizard.workflow.v2.InstallWorkflowFactory;
import com.mathworks.instutil.AvailablePlatform;
import com.mathworks.instutil.InstallerDownloadURLInfo;
import com.mathworks.internal.dws.client.EntitledProduct;
import com.mathworks.internal.dws.client.ReleaseData;
import com.mathworks.wizard.Workflow;
import com.mathworks.wizard.model.DefaultedModel;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.model.ModelImpl;
import com.mathworks.wizard.model.PlatformModel;
import com.mathworks.wizard.ui.panels.PanelStepBuilder;
import java.io.File;
import java.util.Arrays;
import java.util.Properties;

final class DownloadOnlyWorkflow
extends AbstractBranchingInstallWorkflow<String> {
    private static final ReleaseData[] NO_RELEASE_DATA = new ReleaseData[0];
    private static final InstallerDownloadURLInfo[] NO_URLS = new InstallerDownloadURLInfo[0];
    private static final EntitledProduct[] NO_ENTITLED_PRODUCTS = new EntitledProduct[0];
    private final Model<String> token;
    private final Model<Boolean> checkForUpdatesSwitch;
    private final Model<Boolean> getUpdatesSwitch;
    private final Model<ReleaseData[]> releaseDataModel;
    private final InstallWizardContext installWizardContext;
    private final DefaultedModel<File> downloadFolderModel;
    private final Model<DownloaderBuilder> downloaderBuilderModel;
    private final Model<Downloader> downloaderModel;
    private final Model<InstallerDownloadURLInfo[]> urlDataModel;
    private final PlatformModel<AvailablePlatform> platformModel;
    private Model<EntitledProduct[]> entitledProductsModel;
    private Model<String[]> installerNameModel;

    DownloadOnlyWorkflow(InstallModelFactory installModelFactory, InstallCommandStepFactory installCommandStepFactory, InstallWorkflowFactory installWorkflowFactory, Properties properties, String string, InstallWizardContext installWizardContext, DefaultedModel<File> defaultedModel, Model<DownloaderBuilder> model, PlatformModel<AvailablePlatform> platformModel) {
        super(installModelFactory, installCommandStepFactory, installWorkflowFactory, properties);
        this.platformModel = platformModel;
        this.token = new ModelImpl((Object)string);
        this.checkForUpdatesSwitch = new ModelImpl((Object)false);
        this.getUpdatesSwitch = new ModelImpl((Object)false);
        this.releaseDataModel = new ModelImpl((Object)NO_RELEASE_DATA);
        this.installWizardContext = installWizardContext;
        this.downloadFolderModel = defaultedModel;
        this.downloaderBuilderModel = model;
        this.downloaderModel = new ModelImpl();
        this.urlDataModel = new ModelImpl((Object)NO_URLS);
        this.entitledProductsModel = new ModelImpl((Object)NO_ENTITLED_PRODUCTS);
        this.installerNameModel = new ModelImpl();
    }

    @Override
    protected void construct(PanelStepBuilder panelStepBuilder, InstallCommandStepFactory installCommandStepFactory) {
        this.addStep(installCommandStepFactory.createFinishReadingDownloadFolderArchives(this.downloaderBuilderModel));
        this.addStep(installCommandStepFactory.createCheckForUpdatesInDownloadOnlyStep(this.checkForUpdatesSwitch, this.token, this.releaseDataModel, this.entitledProductsModel, this.platformModel));
        this.addStep(installCommandStepFactory.createAlwaysGetUpdatesIfAvailableStep(this.checkForUpdatesSwitch, this.getUpdatesSwitch));
        this.addStep(installCommandStepFactory.createGetUpdatesInDownloadOnlyFlowStep(this.token, this.getUpdatesSwitch, this.releaseDataModel, this.downloaderBuilderModel));
        this.addStep(installCommandStepFactory.createGetInstallerNameForSelectedPlatforms(this.downloaderBuilderModel, this.platformModel, this.installerNameModel, this.getUpdatesSwitch));
        this.addStep(installCommandStepFactory.createGetInstallerInDownloadOnlyCallable(this.getUpdatesSwitch, this.installerNameModel, this.token, this.urlDataModel));
        this.addStep(installCommandStepFactory.createBuildDownloaderStep(this.downloaderBuilderModel, this.downloaderModel, this.urlDataModel, this.entitledProductsModel));
        this.addStep(installCommandStepFactory.createCheckIfAllProductsDownloaded(this.downloaderModel, this.downloadFolderModel));
    }

    @Override
    protected String evaluateWorkflow(InstallWizardProperties installWizardProperties) {
        return ((File)this.downloadFolderModel.get()).getAbsolutePath() + Arrays.toString(this.platformModel.getSelectedPlatforms());
    }

    @Override
    protected Workflow createNewBranch(InstallWorkflowFactory installWorkflowFactory, Properties properties) {
        return installWorkflowFactory.createDownloadProductSelectionWorkflow((Downloader)this.downloaderModel.get(), this.installWizardContext, this.downloadFolderModel, properties, this.platformModel);
    }
}

